/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.sapia.ubik.rmi.server.Log;

public class Localhost {
    private static String LOCALHOST = "0.0.0.0";
    private static String LOOPBACK = "127.0.0.1";
    private static Pattern _pattern;

    public static boolean isIpPatternDefined() {
        return _pattern != null;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        return Localhost.getAnyLocalAddress();
    }

    public static InetAddress getAnyLocalAddress() throws UnknownHostException {
        if (Localhost.isIpPatternDefined()) {
            try {
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    Enumeration<InetAddress> ips = iface.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        InetAddress ia = ips.nextElement();
                        String addr = ia.getHostAddress();
                        if (addr.equals(LOCALHOST) || addr.equals(LOOPBACK) || !Localhost.isLocalAddress(_pattern, addr)) continue;
                        if (Log.isInfo()) {
                            Log.info(Localhost.class, (Object)("Address " + addr + " matches: " + _pattern.toString()));
                        }
                        return ia;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return InetAddress.getLocalHost();
    }

    static boolean isLocalAddress(Pattern pattern, String addr) {
        return pattern.matcher(addr).matches();
    }

    static {
        String patternStr = System.getProperty("ubik.rmi.address-pattern");
        if (patternStr != null) {
            if (Log.isDebug()) {
                Log.debug(Localhost.class, (Object)("Got local network address pattern: " + patternStr));
            }
            _pattern = Pattern.compile(patternStr);
        }
    }
}

