/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.util;

public class StartStopLock {
    public boolean started;
    public boolean stopped;
    public boolean stopRequested;
    private Throwable _startErr;
    private Throwable _stopErr;
    private StopRequestListener _listener;

    public StartStopLock(StopRequestListener listener) {
        this._listener = listener;
    }

    public StartStopLock() {
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public synchronized void triggerStop() {
        this.stopRequested = true;
        if (this._listener != null) {
            try {
                this._listener.onStopRequested();
            }
            catch (Throwable t) {
                this.notifyStopped(t);
                return;
            }
        }
        this.notifyStopped(null);
    }

    public synchronized void waitStarted(long timeout) throws InterruptedException, Throwable {
        while (!this.started && this._startErr == null) {
            this.wait(timeout);
        }
        if (this._startErr != null) {
            throw this._startErr;
        }
    }

    public synchronized void waitStarted() throws InterruptedException, Throwable {
        while (!this.started && this._startErr == null) {
            this.wait();
        }
        if (this._startErr != null) {
            throw this._startErr;
        }
    }

    public synchronized void waitStopped(long timeout) throws InterruptedException, Throwable {
        while (!this.stopped && this._stopErr == null) {
            this.wait(timeout);
        }
        if (this._stopErr != null) {
            throw this._stopErr;
        }
    }

    public synchronized void waitStopped() throws InterruptedException, Throwable {
        while (!this.stopped && this._stopErr == null) {
            this.wait();
        }
        if (this._stopErr != null) {
            throw this._stopErr;
        }
    }

    public synchronized void notifyStarted(Throwable err) {
        this._startErr = err;
        if (err == null) {
            this.started = true;
        }
        this.notifyAll();
    }

    public synchronized void notifyStopped(Throwable err) {
        this._stopErr = err;
        if (err == null) {
            this.stopped = true;
        }
        this.notifyAll();
    }

    public static interface StopRequestListener {
        public void onStopRequested() throws Throwable;
    }
}

