/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.verifiable;

import org.dmfs.jems2.BiFunction;
import org.dmfs.jems2.Fragile;
import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.Function;
import org.dmfs.jems2.Single;
import org.saynotobugs.confidence.junit5.engine.Verifiable;

public final class WithResource
implements Verifiable {
    private final Runnable mDelegate;
    private final String mName;

    public <T> WithResource(Fragile<Resource<T>, Exception> res, Function<T, Verifiable> delegate) {
        this("", res, delegate);
    }

    public <T> WithResource(String name, Fragile<Resource<T>, Exception> res, Function<T, Verifiable> delegate) {
        this(name, () -> {
            try (Resource resource = (Resource)res.value();){
                ((Verifiable)delegate.value(resource.value())).verify();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't create test environment", e);
            }
        });
    }

    public <T, V> WithResource(Fragile<Resource<T>, Exception> res1, Fragile<Resource<V>, Exception> res2, BiFunction<T, V, Verifiable> delegate) {
        this("", res1, res2, delegate);
    }

    public <T, V> WithResource(String name, Fragile<Resource<T>, Exception> res1, Fragile<Resource<V>, Exception> res2, BiFunction<T, V, Verifiable> delegate) {
        this(name, res1, ignored -> (Resource)res2.value(), delegate);
    }

    public <T, V> WithResource(String name, Fragile<Resource<T>, Exception> res1, FragileFunction<T, Resource<V>, Exception> res2, BiFunction<T, V, Verifiable> delegate) {
        this(name, () -> {
            try (Resource resource1 = (Resource)res1.value();
                 Resource resource2 = (Resource)res2.value(resource1.value());){
                ((Verifiable)delegate.value(resource1.value(), resource2.value())).verify();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't create test environment", e);
            }
        });
    }

    private WithResource(String name, Runnable delegate) {
        this.mName = name;
        this.mDelegate = delegate;
    }

    @Override
    public void verify() {
        this.mDelegate.run();
    }

    @Override
    public String name() {
        return this.mName;
    }

    public static interface Resource<T>
    extends Single<T>,
    AutoCloseable {
    }
}

