/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.saynotobugs.confidence.junit5.engine.Verifiable;
import org.saynotobugs.confidence.junit5.engine.testengine.Testable;

public final class FieldTestDescriptor
extends AbstractTestDescriptor
implements Testable {
    private final Class<?> javaClass;
    private final Field javaField;

    public FieldTestDescriptor(UniqueId uniqueId, Class<?> javaClass, Field javaField) {
        super(uniqueId.append("field", javaField.getName()), (javaField.getName().replace("_", " ") + " " + FieldTestDescriptor.assertion(javaClass, javaField).name()).trim(), (TestSource)ClassSource.from(javaClass));
        this.javaClass = javaClass;
        this.javaField = javaField;
    }

    @Override
    public void test(EngineExecutionListener listener) {
        FieldTestDescriptor.assertion(this.javaClass, this.javaField).verify();
    }

    private static Verifiable assertion(Class<?> javaClass, Field javaField) {
        try {
            Constructor<?> constructor = javaClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(new Object[0]);
            javaField.setAccessible(true);
            return (Verifiable)javaField.get(instance);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't invoke test " + javaClass.getName() + "." + javaField.getName(), e);
        }
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }
}

