/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.assertion;

import org.dmfs.jems2.BiFunction;
import org.dmfs.jems2.Function;
import org.saynotobugs.confidence.junit5.engine.Assertion;
import org.saynotobugs.confidence.junit5.engine.Resource;

public final class WithResource
implements Assertion {
    private final Assertion mDelegate;

    public <T> WithResource(Resource<T> res, Function<T, Assertion> delegate) {
        this(() -> {
            try (Resource r = res;){
                ((Assertion)delegate.value(r.value())).verify();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public <T, V> WithResource(Resource<T> res1, Resource<V> res2, BiFunction<T, V, Assertion> delegate) {
        this(() -> {
            try (Resource r1 = res1;
                 Resource r2 = res2;){
                ((Assertion)delegate.value(r1.value(), r2.value())).verify();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private WithResource(Assertion delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public void verify() {
        this.mDelegate.verify();
    }
}

