/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.resource;

import org.dmfs.jems2.Fragile;
import org.dmfs.jems2.FragileProcedure;
import org.saynotobugs.confidence.junit5.engine.Resource;

public final class LazyResource<T>
implements Resource<T> {
    private Fragile<? extends T, Exception> mResourceGenerator;
    private Breakable mCleanUp = () -> {};

    public LazyResource(Fragile<? extends T, Exception> resourceGenerator, FragileProcedure<? super T, Exception> cleanUp) {
        this.mResourceGenerator = () -> {
            LazyResource lazyResource = this;
            synchronized (lazyResource) {
                Object resource = resourceGenerator.value();
                this.mResourceGenerator = () -> resource;
                this.mCleanUp = () -> cleanUp.process(resource);
                return resource;
            }
        };
    }

    @Override
    public T value() {
        try {
            return (T)this.mResourceGenerator.value();
        }
        catch (Exception e) {
            throw new RuntimeException("can't generate resource", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.mCleanUp.run();
    }

    private static interface Breakable {
        public void run() throws Exception;
    }
}

