/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Single;
import org.saynotobugs.confidence.junit5.engine.Resource;

public final class SystemOut
implements Resource<Generator<String>> {
    private Single<? extends Generator<String>> mResourceGenerator;
    private Runnable mCleanUp = () -> {};

    public SystemOut() {
        this.mResourceGenerator = () -> {
            SystemOut systemOut = this;
            synchronized (systemOut) {
                PrintStream original = System.out;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(new TeeStream(out, original));
                System.setOut(ps);
                this.mResourceGenerator = () -> () -> {
                    ps.flush();
                    return out.toString();
                };
                this.mCleanUp = () -> {
                    System.setOut(original);
                    ps.close();
                };
                return (Generator)this.mResourceGenerator.value();
            }
        };
    }

    @Override
    public Generator<String> value() {
        return (Generator)this.mResourceGenerator.value();
    }

    @Override
    public void close() {
        this.mCleanUp.run();
    }

    private static final class TeeStream
    extends OutputStream {
        private final OutputStream mDelegate;
        private final OutputStream mOriginal;

        private TeeStream(OutputStream delegate, OutputStream original) {
            this.mDelegate = delegate;
            this.mOriginal = original;
        }

        @Override
        public void write(int i) throws IOException {
            this.mDelegate.write(i);
            this.mOriginal.write(i);
        }

        @Override
        public void flush() throws IOException {
            this.mDelegate.flush();
            this.mOriginal.flush();
        }

        @Override
        public void close() throws IOException {
            this.mDelegate.close();
        }
    }
}

