/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Reverse;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.iterable.Sieved;
import org.dmfs.jems2.procedure.ForEach;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.saynotobugs.confidence.junit5.engine.Assertion;
import org.saynotobugs.confidence.junit5.engine.Resource;
import org.saynotobugs.confidence.junit5.engine.testengine.Testable;

public final class FieldTestDescriptor
extends AbstractTestDescriptor
implements Testable {
    private final Class<?> javaClass;
    private final Field javaField;

    public FieldTestDescriptor(UniqueId uniqueId, Class<?> javaClass, Field javaField) {
        super(uniqueId.append("field", javaField.getName()), javaField.getName().replace("_", " ").trim(), (TestSource)ClassSource.from(javaClass));
        this.javaClass = javaClass;
        this.javaField = javaField;
    }

    @Override
    public void test(EngineExecutionListener listener) {
        Object instance = null;
        try {
            Constructor<?> constructor = this.javaClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            instance = constructor.newInstance(new Object[0]);
            this.javaField.setAccessible(true);
            ((Assertion)this.javaField.get(instance)).verify();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't invoke test " + this.javaClass.getName() + "." + this.javaField.getName(), e);
        }
        finally {
            if (instance != null) {
                Object finalInstance = instance;
                new ForEach((Iterable)new Mapped(field -> {
                    field.setAccessible(true);
                    try {
                        return (Resource)field.get(finalInstance);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }, (Iterable)new Sieved(field -> Resource.class.isAssignableFrom(field.getType()), (Iterable)new Reverse((Iterable)new Seq((Object[])this.javaClass.getDeclaredFields()))))).process(resource -> {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }
}

