/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.quality;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.dmfs.jems2.Generator;
import org.dmfs.jems2.confidence.Jems2;
import org.saynotobugs.confidence.Quality;
import org.saynotobugs.confidence.junit5.engine.Resource;
import org.saynotobugs.confidence.junit5.engine.ResourceHandle;
import org.saynotobugs.confidence.quality.Core;
import org.saynotobugs.confidence.quality.composite.QualityComposition;

public final class DelegatingResourceThat<Original, T>
extends QualityComposition<Function<Resource<Original>, Resource<T>>> {
    public DelegatingResourceThat(Generator<Original> originalGenerator, Quality<? super T> delegate) {
        this((Quality<ResourceHandle<T>>)Core.autoClosableThat((Quality)Jems2.hasValue(delegate)), originalGenerator);
    }

    public DelegatingResourceThat(Generator<Original> originalGenerator, Quality<? super T> delegate, Quality<? super T> cleanUpDelegate) {
        this((Quality<ResourceHandle<T>>)Core.allOf((Quality[])new Quality[]{Core.autoClosableThat((Quality)Jems2.hasValue(delegate)), Jems2.hasValue(cleanUpDelegate)}), originalGenerator);
    }

    private DelegatingResourceThat(Quality<? super ResourceHandle<T>> delegate, Generator<Original> originalGenerator) {
        super((Quality)Core.mutatesArgument(() -> new TestResource(originalGenerator.next()), (Quality)Core.soIt((Quality)Core.allOf((Quality[])new Quality[]{Core.has((String)"times open", r -> ((TestResource)r).mTimesOpen, (Quality)Core.hasLongValue((long)1L)), Core.has((String)"times closed", r -> ((TestResource)r).mTimesClosed, (Quality)Core.hasLongValue((long)1L))})), (Quality)Core.when((Quality)Core.has((String)"single use", Resource::value, delegate))));
    }

    private static final class TestResource<T>
    implements Resource<T> {
        private final T mResource;
        private final AtomicInteger mTimesOpen = new AtomicInteger();
        private final AtomicInteger mTimesClosed = new AtomicInteger();

        private TestResource(T resource) {
            this.mResource = resource;
        }

        @Override
        public ResourceHandle<T> value() {
            if (this.mTimesClosed.get() > 0) {
                throw new AssertionError((Object)"resource value called after closing");
            }
            this.mTimesOpen.incrementAndGet();
            return new ResourceHandle<T>(){

                @Override
                public void close() {
                    mTimesClosed.incrementAndGet();
                }

                public T value() {
                    if (mTimesClosed.get() > 0) {
                        throw new AssertionError((Object)"resource handle value called after closing");
                    }
                    return mResource;
                }
            };
        }
    }
}

