/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Optional;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.saynotobugs.confidence.junit5.engine.Assertion;
import org.saynotobugs.confidence.junit5.engine.testengine.Testable;
import org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor.FieldTestDescriptor;
import org.saynotobugs.confidence.utils.FailSafe;

public final class ClassTestDescriptor
extends AbstractTestDescriptor
implements Testable {
    public ClassTestDescriptor(UniqueId uniqueId, Class<?> javaClass) {
        super(uniqueId.append("class", javaClass.getName()), javaClass.getSimpleName(), (TestSource)ClassSource.from(javaClass));
        Arrays.stream(javaClass.getDeclaredFields()).filter(field -> Assertion.class.isAssignableFrom(field.getType())).map(field -> new FieldTestDescriptor(this.getUniqueId(), javaClass, ClassTestDescriptor.testSources(javaClass), (Field)field)).forEach(arg_0 -> ((ClassTestDescriptor)this).addChild(arg_0));
    }

    @Override
    public void test(EngineExecutionListener listener) {
        this.children.forEach(descriptor -> {
            listener.executionStarted(descriptor);
            try {
                ((Testable)descriptor).test(listener);
                listener.executionFinished(descriptor, TestExecutionResult.successful());
            }
            catch (Throwable e) {
                listener.executionFinished(descriptor, TestExecutionResult.failed((Throwable)e));
            }
        });
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static Optional<CompilationUnit> testSources(Class<?> clazz) {
        return ClassTestDescriptor.gradleTestSourcePath(clazz).or(() -> ClassTestDescriptor.naiveTestSourcePath(clazz)).flatMap(new FailSafe(any -> Optional.empty(), path -> new JavaParser().parse(path).getResult()));
    }

    private static Optional<Path> naiveTestSourcePath(Class<?> testClazz) {
        return Optional.of(Path.of("src", "main").resolve(Path.of("java", testClazz.getPackage().getName().split("\\."))).resolve(testClazz.getSimpleName() + ".java")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    private static Optional<Path> gradleTestSourcePath(Class<?> testClazz) {
        return Optional.ofNullable(System.getProperty("user.dir")).map(x$0 -> Path.of(x$0, new String[0])).flatMap(workingDir -> Optional.ofNullable(testClazz.getProtectionDomain().getCodeSource()).map(CodeSource::getLocation).flatMap(new FailSafe(any -> Optional.empty(), url -> Optional.of(url.toURI()))).map(source -> workingDir.relativize(Path.of(source))).map(relativeClassPath -> workingDir.resolve(Path.of("src", relativeClassPath.getName(3).toString()).resolve(Path.of(relativeClassPath.getName(2).toString(), testClazz.getPackageName().split("\\."))).resolve(testClazz.getSimpleName() + ".java"))).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
    }
}

