/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.saynotobugs.confidence.junit5.engine.ResourceComposition;
import org.saynotobugs.confidence.junit5.engine.resource.LazyResource;

public final class TempDir
extends ResourceComposition<File> {
    public TempDir() {
        this("TempDir");
    }

    public TempDir(String prefix) {
        super(new LazyResource(() -> Files.createTempDirectory(prefix, new FileAttribute[0]).toFile(), TempDir::delete));
    }

    private static void delete(File file) throws IOException {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                f.setWritable(true);
                TempDir.delete(f);
            }
        }
        Files.deleteIfExists(file.toPath());
    }
}

