/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.saynotobugs.confidence.junit5.engine.Assertion;
import org.saynotobugs.confidence.junit5.engine.testengine.Testable;

public final class FieldTestDescriptor
extends AbstractTestDescriptor
implements Testable {
    private final Class<?> javaClass;
    private final Field javaField;

    public FieldTestDescriptor(UniqueId uniqueId, Class<?> javaClass, Optional<CompilationUnit> testSource, Field javaField) {
        super(uniqueId.append("field", javaField.getName()), javaField.getName().replace("_", " ").trim(), (TestSource)ClassSource.from(javaClass, (FilePosition)FieldTestDescriptor.getFieldLineNumber(testSource, javaField.getName())));
        this.javaClass = javaClass;
        this.javaField = javaField;
    }

    @Override
    public void test(EngineExecutionListener listener) {
        try {
            Constructor<?> constructor = this.javaClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(new Object[0]);
            this.javaField.setAccessible(true);
            ((Assertion)this.javaField.get(instance)).verify();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't invoke test " + this.javaClass.getName() + "." + this.javaField.getName(), e);
        }
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    private static FilePosition getFieldLineNumber(Optional<CompilationUnit> compilationUnit, String fieldName) {
        return compilationUnit.flatMap(cu -> cu.findAll(FieldDeclaration.class).stream().flatMap(fieldDeclaration -> fieldDeclaration.getVariables().stream()).filter(node -> fieldName.equals(node.getName().asString())).flatMap(node -> node.getBegin().stream()).map(begin -> FilePosition.from((int)begin.line, (int)begin.column)).findFirst()).orElse(null);
    }
}

