/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.resource;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmfs.jems2.Fragile;
import org.dmfs.jems2.FragileBiProcedure;
import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.FragileProcedure;
import org.saynotobugs.confidence.junit5.engine.Resource;
import org.saynotobugs.confidence.junit5.engine.ResourceHandle;

public final class LazyResource<T>
implements Resource<T> {
    private final AtomicInteger mRefCount = new AtomicInteger(0);
    private Fragile<T, Exception> mResourceSource;
    private Breakable mCleanUp = () -> {};

    public LazyResource(Fragile<T, Exception> resourceSource, FragileProcedure<? super T, Exception> cleanUp) {
        this(resourceSource, context -> context, (resourceValue, context) -> cleanUp.process(resourceValue));
    }

    public <Context> LazyResource(final Fragile<Context, Exception> contextSource, final FragileFunction<? super Context, ? extends T, Exception> contextToValueFunction, final FragileBiProcedure<? super T, ? super Context, Exception> cleanUp) {
        this.mResourceSource = new Fragile<T, Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T value() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (LazyResource.this.mResourceSource == this) {
                        Object context = contextSource.value();
                        Object value = contextToValueFunction.value(context);
                        LazyResource.this.mResourceSource = () -> value;
                        LazyResource.this.mCleanUp = () -> cleanUp.process(value, context);
                        return value;
                    }
                    return LazyResource.this.mResourceSource.value();
                }
            }
        };
    }

    @Override
    public ResourceHandle<T> value() throws Exception {
        this.mRefCount.incrementAndGet();
        final Object resourceValue = this.mResourceSource.value();
        return new ResourceHandle<T>(){
            private final AtomicBoolean mClosed = new AtomicBoolean(false);

            public T value() {
                return resourceValue;
            }

            @Override
            public void close() throws Exception {
                if (!this.mClosed.compareAndSet(false, true)) {
                    throw new IllegalStateException("ResourceHandle already closed");
                }
                if (LazyResource.this.mRefCount.decrementAndGet() == 0) {
                    LazyResource.this.mCleanUp.run();
                }
            }
        };
    }

    private static interface Breakable {
        public void run() throws Exception;
    }
}

