/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.json.jsonpathadapter;

import io.restassured.path.json.JsonPath;
import java.util.List;
import java.util.Map;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.Absent;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Present;
import org.dmfs.jems2.optional.Sieved;
import org.saynotobugs.confidence.json.JsonArrayAdapter;
import org.saynotobugs.confidence.json.JsonElementAdapter;
import org.saynotobugs.confidence.json.JsonObjectAdapter;
import org.saynotobugs.confidence.json.jsonpathadapter.ArrayAdapter;
import org.saynotobugs.confidence.json.jsonpathadapter.ObjectAdapter;

public final class JsonPathElementAdapter
implements JsonElementAdapter {
    private final JsonPath mJsonPath;
    private final String mPath;

    public JsonPathElementAdapter(JsonPath jsonPath, String path) {
        this.mJsonPath = jsonPath;
        this.mPath = path;
    }

    @Override
    public Optional<JsonObjectAdapter> asObject() {
        return this.mJsonPath.get(this.mPath) instanceof Map ? new Present((Object)new ObjectAdapter(this.mJsonPath, this.mPath)) : new Absent();
    }

    @Override
    public Optional<JsonArrayAdapter> asArray() {
        return this.mJsonPath.get(this.mPath) instanceof List ? new Present((Object)new ArrayAdapter(this.mJsonPath, this.mPath)) : new Absent();
    }

    @Override
    public Optional<String> asString() {
        return new Mapped(String.class::cast, (Optional)new Sieved(String.class::isInstance, (Optional)new NullSafe(this.mJsonPath.get(this.mPath))));
    }

    @Override
    public Optional<Number> asNumber() {
        return new Mapped(Number.class::cast, (Optional)new Sieved(Number.class::isInstance, (Optional)new NullSafe(this.mJsonPath.get(this.mPath))));
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return new Mapped(Boolean.class::cast, (Optional)new Sieved(Boolean.class::isInstance, (Optional)new NullSafe(this.mJsonPath.get(this.mPath))));
    }

    @Override
    public boolean isNull() {
        return this.mJsonPath.get(this.mPath) == null;
    }

    public String toString() {
        return this.mJsonPath.prettify();
    }
}

