/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.json.jsonstringadapter;

import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.optional.Absent;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Present;
import org.dmfs.jems2.optional.Restrained;
import org.dmfs.jems2.optional.Sieved;
import org.dmfs.jems2.predicate.AnyOf;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.saynotobugs.confidence.json.JsonArrayAdapter;
import org.saynotobugs.confidence.json.JsonElementAdapter;
import org.saynotobugs.confidence.json.JsonObjectAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ArrayAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ObjectAdapter;

public final class JsonStringElementAdapter
implements JsonElementAdapter {
    private final String mJsonString;

    public JsonStringElementAdapter(String jsonString) {
        this.mJsonString = jsonString;
    }

    @Override
    public Optional<JsonObjectAdapter> asObject() {
        try {
            return new Present((Object)new ObjectAdapter(new JSONObject(this.mJsonString)));
        }
        catch (JSONException e) {
            return Absent.absent();
        }
    }

    @Override
    public Optional<JsonArrayAdapter> asArray() {
        try {
            return new Present((Object)new ArrayAdapter(new JSONArray(this.mJsonString)));
        }
        catch (JSONException e) {
            return Absent.absent();
        }
    }

    @Override
    public Optional<String> asString() {
        try {
            return new Restrained(() -> this.mJsonString.startsWith("\"") && this.mJsonString.endsWith("\""), (Optional)new Mapped(Object::toString, (Optional)new Sieved(String.class::isInstance, (Optional)new NullSafe(new JSONArray("[" + this.mJsonString + "]").get(0)))));
        }
        catch (JSONException e) {
            return Absent.absent();
        }
    }

    @Override
    public Optional<Number> asNumber() {
        try {
            return new Mapped(Number.class::cast, (Optional)new Sieved(Number.class::isInstance, (Optional)new NullSafe(new JSONArray("[" + this.mJsonString + "]").opt(0))));
        }
        catch (JSONException e) {
            return Absent.absent();
        }
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return new Mapped(Boolean::parseBoolean, (Optional)new Sieved((Predicate)new AnyOf((Object[])new String[]{"true", "false"}), (Optional)new Present((Object)this.mJsonString)));
    }

    @Override
    public boolean isNull() {
        return "null".equals(this.mJsonString);
    }

    public String toString() {
        return this.mJsonString;
    }
}

