/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.json.jsonstringadapter;

import java.util.Objects;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Sieved;
import org.dmfs.jems2.single.Backed;
import org.json.JSONObject;
import org.saynotobugs.confidence.json.JsonArrayAdapter;
import org.saynotobugs.confidence.json.JsonElementAdapter;
import org.saynotobugs.confidence.json.JsonObjectAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ArrayAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ObjectAdapter;

public final class ObjectMemberAdapter
implements JsonElementAdapter {
    private final JSONObject mObject;
    private final String mKey;

    public ObjectMemberAdapter(JSONObject object, String key) {
        this.mObject = object;
        this.mKey = key;
    }

    @Override
    public Optional<JsonObjectAdapter> asObject() {
        return new Mapped(ObjectAdapter::new, (Optional)new NullSafe((Object)this.mObject.optJSONObject(this.mKey, null)));
    }

    @Override
    public Optional<JsonArrayAdapter> asArray() {
        return new Mapped(ArrayAdapter::new, (Optional)new NullSafe((Object)this.mObject.optJSONArray(this.mKey)));
    }

    @Override
    public Optional<String> asString() {
        return new Mapped(Object::toString, (Optional)new Sieved(String.class::isInstance, (Optional)new NullSafe(this.mObject.opt(this.mKey))));
    }

    @Override
    public Optional<Number> asNumber() {
        return new Mapped(Number.class::cast, (Optional)new Sieved(Number.class::isInstance, (Optional)new NullSafe(this.mObject.opt(this.mKey))));
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return new Mapped(Boolean.TRUE::equals, (Optional)new Sieved(Boolean.class::isInstance, (Optional)new NullSafe(this.mObject.opt(this.mKey))));
    }

    @Override
    public boolean isNull() {
        return this.mObject.has(this.mKey) && this.mObject.isNull(this.mKey);
    }

    public String toString() {
        return (String)new Backed((Optional)new Mapped(Objects::toString, (Optional)new NullSafe(this.mObject.opt(this.mKey))), (Object)"null").value();
    }
}

