/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.json.jsonstringadapter;

import java.util.Objects;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Sieved;
import org.dmfs.jems2.single.Backed;
import org.json.JSONArray;
import org.saynotobugs.confidence.json.JsonArrayAdapter;
import org.saynotobugs.confidence.json.JsonElementAdapter;
import org.saynotobugs.confidence.json.JsonObjectAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ArrayAdapter;
import org.saynotobugs.confidence.json.jsonstringadapter.ObjectAdapter;

public final class ArrayElementAdapter
implements JsonElementAdapter {
    private final JSONArray mArray;
    private final int mIndex;

    public ArrayElementAdapter(JSONArray array, int index) {
        this.mArray = array;
        this.mIndex = index;
    }

    @Override
    public Optional<JsonObjectAdapter> asObject() {
        return new Mapped(ObjectAdapter::new, (Optional)new NullSafe((Object)this.mArray.optJSONObject(this.mIndex)));
    }

    @Override
    public Optional<JsonArrayAdapter> asArray() {
        return new Mapped(ArrayAdapter::new, (Optional)new NullSafe((Object)this.mArray.optJSONArray(this.mIndex)));
    }

    @Override
    public Optional<String> asString() {
        return new Mapped(Object::toString, (Optional)new Sieved(String.class::isInstance, (Optional)new NullSafe(this.mArray.opt(this.mIndex))));
    }

    @Override
    public Optional<Number> asNumber() {
        return new Mapped(Number.class::cast, (Optional)new Sieved(Number.class::isInstance, (Optional)new NullSafe(this.mArray.opt(this.mIndex))));
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return new Mapped(Boolean.TRUE::equals, (Optional)new Sieved(Boolean.class::isInstance, (Optional)new NullSafe(this.mArray.opt(this.mIndex))));
    }

    @Override
    public boolean isNull() {
        return this.mIndex < this.mArray.length() && this.mArray.isNull(this.mIndex);
    }

    public String toString() {
        return (String)new Backed((Optional)new Mapped(Objects::toString, (Optional)new NullSafe(this.mArray.opt(this.mIndex))), (Object)"null").value();
    }
}

