/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.util.IdManager;

public class ArraysSBasePlugin
extends AbstractSBasePlugin
implements IdManager {
    private static final long serialVersionUID = -5467877915615614247L;
    private static final transient Logger logger = Logger.getLogger(ArraysSBasePlugin.class);
    Map<String, Dimension> mapOfDimensions;
    private ListOf<Index> listOfIndices;
    private ListOf<Dimension> listOfDimensions;

    public ArraysSBasePlugin() {
        this.initDefaults();
    }

    public ArraysSBasePlugin(SBase extendedSBase) {
        super(extendedSBase);
        this.initDefaults();
    }

    public ArraysSBasePlugin(ArraysSBasePlugin obj) {
        super((SBasePlugin)obj);
        if (obj.isSetListOfDimensions()) {
            this.setListOfDimensions((ListOf<Dimension>)obj.listOfDimensions.clone());
        }
        if (obj.isSetListOfIndices()) {
            this.setListOfIndices((ListOf<Index>)obj.listOfIndices.clone());
        }
    }

    public ArraysSBasePlugin clone() {
        return new ArraysSBasePlugin(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
    }

    public boolean isSetListOfIndices() {
        return this.listOfIndices != null && !this.listOfIndices.isEmpty();
    }

    public ListOf<Index> getListOfIndices() {
        if (!this.isSetListOfIndices()) {
            this.listOfIndices = new ListOf();
            this.listOfIndices.setPackageVersion(-1);
            this.listOfIndices.setPackageName(null);
            this.listOfIndices.setPackageName("arrays");
            this.listOfIndices.setSBaseListType(ListOf.Type.other);
            this.listOfIndices.setOtherListName("listOfIndices");
            if (this.isSetExtendedSBase()) {
                this.extendedSBase.registerChild(this.listOfIndices);
            }
        }
        return this.listOfIndices;
    }

    public void setListOfIndices(ListOf<Index> listOfIndices) {
        this.unsetListOfIndices();
        this.listOfIndices = listOfIndices;
        if (listOfIndices != null) {
            listOfIndices.setPackageVersion(-1);
            listOfIndices.setPackageName(null);
            listOfIndices.setPackageName("arrays");
            listOfIndices.setSBaseListType(ListOf.Type.other);
            listOfIndices.setOtherListName("listOfIndices");
        }
        if (this.isSetExtendedSBase()) {
            this.extendedSBase.registerChild(this.listOfIndices);
        }
    }

    public boolean unsetListOfIndices() {
        if (this.isSetListOfIndices()) {
            ListOf<Index> oldIndices = this.listOfIndices;
            this.listOfIndices = null;
            oldIndices.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addIndex(Index field) {
        return this.getListOfIndices().add((SBase)field);
    }

    public boolean removeIndex(Index field) {
        if (this.isSetListOfIndices()) {
            return this.getListOfIndices().remove((Object)field);
        }
        return false;
    }

    public boolean removeIndexByArrayDimension(int arrayDim) {
        if (this.isSetListOfIndices()) {
            ListOf<Index> list = this.getListOfIndices();
            for (Index index : list) {
                if (!index.isSetArrayDimension() || index.getArrayDimension() != arrayDim) continue;
                return index.removeFromParent();
            }
        }
        return false;
    }

    public Index removeIndex(int i) {
        if (!this.isSetListOfIndices()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Index)this.getListOfIndices().remove(i);
    }

    public Index createIndex() {
        Index field = new Index();
        this.addIndex(field);
        return field;
    }

    public Index getIndex(int i) {
        if (!this.isSetListOfIndices()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Index)this.getListOfIndices().get(i);
    }

    public Index getIndex(int dim, String attribute) {
        if (this.isSetListOfIndices()) {
            ListOf<Index> list = this.getListOfIndices();
            for (Index index : list) {
                if (!index.isSetArrayDimension() || !index.isSetReferencedAttribute() || index.getArrayDimension() != dim || !index.getReferencedAttribute().equals(attribute)) continue;
                return index;
            }
        }
        return null;
    }

    public int getIndexCount() {
        return this.isSetListOfIndices() ? this.getListOfIndices().size() : 0;
    }

    public int getNumIndices() {
        return this.getIndexCount();
    }

    public boolean isSetListOfDimensions() {
        return this.listOfDimensions != null && !this.listOfDimensions.isEmpty();
    }

    public ListOf<Dimension> getListOfDimensions() {
        if (!this.isSetListOfDimensions()) {
            this.listOfDimensions = new ListOf();
            this.listOfDimensions.setPackageVersion(-1);
            this.listOfDimensions.setPackageName(null);
            this.listOfDimensions.setPackageName("arrays");
            this.listOfDimensions.setSBaseListType(ListOf.Type.other);
            this.listOfDimensions.setOtherListName("listOfDimensions");
            if (this.isSetExtendedSBase()) {
                this.extendedSBase.registerChild(this.listOfDimensions);
            }
        }
        return this.listOfDimensions;
    }

    public void setListOfDimensions(ListOf<Dimension> listOfDimensions) {
        this.unsetListOfDimensions();
        this.listOfDimensions = listOfDimensions;
        if (listOfDimensions != null) {
            listOfDimensions.setPackageVersion(-1);
            listOfDimensions.setPackageName(null);
            listOfDimensions.setPackageName("arrays");
            listOfDimensions.setSBaseListType(ListOf.Type.other);
            listOfDimensions.setOtherListName("listOfDimensions");
        }
        if (this.isSetExtendedSBase()) {
            this.extendedSBase.registerChild(this.listOfDimensions);
        }
    }

    public boolean unsetListOfDimensions() {
        if (this.isSetListOfDimensions()) {
            ListOf<Dimension> oldDimensions = this.listOfDimensions;
            this.listOfDimensions = null;
            oldDimensions.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addDimension(Dimension field) {
        return this.getListOfDimensions().add((SBase)field);
    }

    public boolean removeDimension(Dimension field) {
        if (this.isSetListOfDimensions()) {
            return this.getListOfDimensions().remove((NamedSBase)field);
        }
        return false;
    }

    public Dimension removeDimension(String fieldId) {
        if (this.isSetListOfDimensions()) {
            return (Dimension)this.getListOfDimensions().remove(fieldId);
        }
        return null;
    }

    public Dimension removeDimensionByArrayDimension(int arrayDim) {
        if (this.isSetListOfDimensions()) {
            Dimension dimension = this.getDimensionByArrayDimension(arrayDim);
            if (dimension != null) {
                dimension.removeFromParent();
            }
            return dimension;
        }
        return null;
    }

    public Dimension removeDimension(int i) {
        if (!this.isSetListOfDimensions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Dimension)this.getListOfDimensions().remove(i);
    }

    public Dimension createDimension() {
        return this.createDimension(null);
    }

    public Dimension createDimension(String id) {
        Dimension field = new Dimension(id);
        this.addDimension(field);
        return field;
    }

    public Dimension getDimension(int i) {
        if (!this.isSetListOfDimensions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Dimension)this.getListOfDimensions().get(i);
    }

    public Dimension getDimensionByArrayDimension(int i) {
        if (this.isSetListOfDimensions()) {
            for (Dimension dim : this.getListOfDimensions()) {
                if (!dim.isSetArrayDimension() || dim.getArrayDimension() != i) continue;
                return dim;
            }
        }
        return null;
    }

    public Dimension getDimension(String fieldId) {
        if (this.isSetListOfDimensions()) {
            return (Dimension)this.getListOfDimensions().get(fieldId);
        }
        return null;
    }

    public int getDimensionCount() {
        return this.isSetListOfDimensions() ? this.getListOfDimensions().size() : 0;
    }

    public int getNumDimensions() {
        return this.getDimensionCount();
    }

    public String getElementNamespace() {
        return ArraysConstants.getNamespaceURI(this.getLevel(), this.getVersion());
    }

    public String getPackageName() {
        return "arrays";
    }

    public String getPrefix() {
        return "arrays";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfDimensions()) {
            if (pos == childIndex) {
                return this.getListOfDimensions();
            }
            ++pos;
        }
        if (this.isSetListOfIndices()) {
            if (pos == childIndex) {
                return this.getListOfIndices();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,  number, integer} >= {1, number, integer}", childIndex, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfDimensions()) {
            ++count;
        }
        if (this.isSetListOfIndices()) {
            ++count;
        }
        return count;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        return attributes;
    }

    public boolean accept(SBase sbase) {
        return sbase instanceof Dimension;
    }

    public boolean register(SBase sbase) {
        boolean success = true;
        if (sbase instanceof Dimension) {
            Dimension dimension = (Dimension)sbase;
            if (dimension.isSetId()) {
                String id = dimension.getId();
                if (this.mapOfDimensions == null) {
                    this.mapOfDimensions = new HashMap<String, Dimension>();
                }
                if (this.mapOfDimensions.containsKey(id)) {
                    String elementName = null;
                    String elementId = null;
                    if (this.isSetExtendedSBase()) {
                        elementName = this.getExtendedSBase().getElementName();
                        if (this.getExtendedSBase() instanceof NamedSBase) {
                            elementId = "id[" + ((NamedSBase)this.getExtendedSBase()).getId() + "]";
                        } else if (this.getExtendedSBase().isSetMetaId()) {
                            elementId = "metaid[" + this.getExtendedSBase().getMetaId() + "]";
                        }
                    }
                    if (this.mapOfDimensions.get(id) == sbase) {
                        success = true;
                    } else {
                        logger.error((Object)MessageFormat.format("A Dimension with the id \"{0}\" is already present in this {1}{2}. The new element will not be added to the model.", id, elementName, elementId != null ? " identified by " + elementId : ""));
                        success = false;
                    }
                } else {
                    this.mapOfDimensions.put(id, dimension);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("registered Dimension id=\"{0}\" in {1}", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    }
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to register something that is not a Dimension: \"{0}\".", sbase));
        }
        return success;
    }

    public boolean unregister(SBase sbase) {
        boolean success = true;
        if (sbase instanceof Dimension) {
            Dimension dimension = (Dimension)sbase;
            if (dimension.isSetId()) {
                String id = dimension.getId();
                if (this.mapOfDimensions == null) {
                    logger.warn((Object)MessageFormat.format("No Dimension have been registered in this {0}. Nothing to be done.", this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    return success;
                }
                if (this.mapOfDimensions.containsKey(id)) {
                    this.mapOfDimensions.remove(id);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("unregistered Dimension id={0} in {1}", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    }
                } else {
                    String elementName = null;
                    String elementId = null;
                    if (this.isSetExtendedSBase()) {
                        elementName = this.getExtendedSBase().getElementName();
                        if (this.getExtendedSBase() instanceof NamedSBase) {
                            elementId = "id[" + ((NamedSBase)this.getExtendedSBase()).getId() + "]";
                        } else if (this.getExtendedSBase().isSetMetaId()) {
                            elementId = "metaid[" + this.getExtendedSBase().getMetaId() + "]";
                        }
                    }
                    logger.warn((Object)MessageFormat.format("A Dimension with the id \"{0}\" is not present in this {1}{2}. Nothing to be done.", id, elementName, elementId != null ? " identified by " + elementId : ""));
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to unregister something that is not a Dimension: \"{0}\".", sbase));
        }
        return success;
    }

    public int hashCode() {
        int prime = 2719;
        int result = super.hashCode();
        result = 2719 * result + (this.listOfDimensions == null ? 0 : this.listOfDimensions.hashCode());
        result = 2719 * result + (this.listOfIndices == null ? 0 : this.listOfIndices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ArraysSBasePlugin other = (ArraysSBasePlugin)((Object)obj);
        if (this.listOfDimensions == null ? other.listOfDimensions != null : !this.listOfDimensions.equals(other.listOfDimensions)) {
            return false;
        }
        return !(this.listOfIndices == null ? other.listOfIndices != null : !this.listOfIndices.equals(other.listOfIndices));
    }
}

