/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class DimensionArrayDimCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final SBase sbase;

    public DimensionArrayDimCheck(Model model, SBase sbase) {
        super(model);
        this.sbase = sbase;
    }

    @Override
    public void check() {
        if (this.model == null || this.sbase == null) {
            return;
        }
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)this.sbase.getExtension("arrays");
        int max = -1;
        if (arraysSBasePlugin == null) {
            return;
        }
        for (Object dim : arraysSBasePlugin.getListOfDimensions()) {
            if (!dim.isSetArrayDimension() || dim.getArrayDimension() <= max) continue;
            max = dim.getArrayDimension();
        }
        boolean[] isSetArrayDimAt = new boolean[max + 1];
        for (Dimension dim : arraysSBasePlugin.getListOfDimensions()) {
            if (!dim.isSetArrayDimension()) continue;
            int arrayDim = dim.getArrayDimension();
            if (!isSetArrayDimAt[arrayDim]) {
                isSetArrayDimAt[arrayDim] = true;
                continue;
            }
            String shortMsg = MessageFormat.format("A listOfDimensions should have Dimension objects with unique attribute arrays:arrayDimension, but the value {0,number,integer} is used multiple times.", arrayDim);
            this.logArrayDimensionUniqueness(shortMsg);
        }
        for (int i = 0; i <= max; ++i) {
            if (isSetArrayDimAt[i]) continue;
            String shortMsg = MessageFormat.format("A listOfDimensions should have a Dimension with arrays:arrayDimension {0,number,integer} before adding a Dimension object with arrays:arrayDimension {1,number,integer}", i, max);
            this.logArrayDimensionMissing(shortMsg);
            return;
        }
    }

    private void logArrayDimensionUniqueness(String shortMsg) {
        int code = 8020104;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("DimensionArrayDimCheck.logArrayDimensionUniqueness");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logArrayDimensionMissing(String shortMsg) {
        int code = 8020103;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("DimensionArrayDimCheck.logArrayDimensionMissing");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

