/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class DimensionSizeCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final Dimension dim;

    public DimensionSizeCheck(Model model, Dimension dim) {
        super(model);
        this.dim = dim;
    }

    @Override
    public void check() {
        if (this.model == null || this.dim == null) {
            return;
        }
        if (!this.dim.isSetSize()) {
            String shortMsg = MessageFormat.format("Dimension objects shoud have a value for the attribute arrays:size but {0} does not have one.", this.dim.toString());
            this.logMissingDimensionAttribute(shortMsg);
        } else {
            this.checkSize(this.dim.getSize());
        }
    }

    private void checkSize(String id) {
        ArraysSBasePlugin arraysSBasePlugin;
        String shortMsg;
        Parameter param = this.model.getParameter(id);
        if (param == null) {
            String shortMsg2 = MessageFormat.format("The attribute arrays:size of a Dimension object should point to an existing parameter but {0} points to a non-existing parameter", this.dim.toString());
            this.logDimensionSizeInvalid(shortMsg2);
            return;
        }
        if (!param.isConstant()) {
            shortMsg = MessageFormat.format("The attribute arrays:size of a Dimension object should point to a constant parameter but {0} has a non-constant value.", this.dim.toString());
            this.logDimensionSizeValueInconsistency(shortMsg);
        }
        if (param.getValue() % 1.0 != 0.0) {
            shortMsg = "The attribute arrays:size of a Dimension object should point to a parameter containing an integer value.";
            this.logDimensionSizeValueInconsistency(shortMsg);
        }
        if (param.getValue() < 0.0) {
            shortMsg = MessageFormat.format("The attribute arrays:size of a Dimension object should point to a parameter that has a non-negative integer value but {0} has a negative value.", this.dim.toString());
            this.logDimensionSizeValueInconsistency(shortMsg);
        }
        if ((arraysSBasePlugin = (ArraysSBasePlugin)param.getExtension("arrays")) != null && arraysSBasePlugin.getDimensionCount() > 0) {
            String shortMsg3 = MessageFormat.format("The attribute arrays:size of a Dimension object should point to a scalar parameter but {0} has a non-scalar value.", this.dim.toString());
            this.logDimensionSizeInvalid(shortMsg3);
        }
    }

    private void logMissingDimensionAttribute(String shortMsg) {
        int code = 8020202;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("DimensionSizeCheck.logMissingDimensionAttribute");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logDimensionSizeInvalid(String shortMsg) {
        int code = 8020204;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("DimensionSizeCheck.logDimensionSizeInvalid");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logDimensionSizeValueInconsistency(String shortMsg) {
        int code = 8020205;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("DimensionSizeCheck.logDimensionSizeValueInconsistency");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

