/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class IndexArrayDimCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final SBase sbase;

    public IndexArrayDimCheck(Model model, SBase sbase) {
        super(model);
        this.sbase = sbase;
    }

    @Override
    public void check() {
        if (this.model == null || this.sbase == null) {
            return;
        }
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)this.sbase.getExtension("arrays");
        HashMap<String, Integer> attributeToMaxDim = new HashMap<String, Integer>();
        if (arraysSBasePlugin == null || arraysSBasePlugin.getIndexCount() == 0) {
            return;
        }
        for (Index index : arraysSBasePlugin.getListOfIndices()) {
            if (attributeToMaxDim.containsKey(index.getReferencedAttribute()) && index.getArrayDimension() <= (Integer)attributeToMaxDim.get(index.getReferencedAttribute())) continue;
            attributeToMaxDim.put(index.getReferencedAttribute(), index.getArrayDimension());
        }
        for (String attribute : attributeToMaxDim.keySet()) {
            int max = (Integer)attributeToMaxDim.get(attribute);
            boolean[] isSetArrayDimAt = new boolean[max + 1];
            for (Index index : arraysSBasePlugin.getListOfIndices()) {
                if (!index.getReferencedAttribute().equals(attribute)) continue;
                int arrayDim = index.getArrayDimension();
                if (!isSetArrayDimAt[arrayDim]) {
                    isSetArrayDimAt[arrayDim] = true;
                    continue;
                }
                String shortMsg = MessageFormat.format("A listOfIndices should have Index objects with unique attribute arrays:arrayDimension, but the value {0,number,integer} is used multiple times.", arrayDim);
                this.logArrayDimensionUniqueness(shortMsg);
            }
            for (int i = 0; i <= max; ++i) {
                if (isSetArrayDimAt[i]) continue;
                String shortMsg = MessageFormat.format("A listOfIndices should have an Index with arrays:arrayDimension {0,number,integer} before adding an Index object with arrays:arrayDimension {1,number,integer}", i, max);
                this.logArrayDimensionMissing(shortMsg);
                return;
            }
        }
    }

    private void logArrayDimensionUniqueness(String shortMsg) {
        int code = 8020111;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexArrayDimCheck.logArrayDimensionUniqueness");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logArrayDimensionMissing(String shortMsg) {
        int code = 8020110;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexArrayDimCheck.logArrayDimensionMissing");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

