/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.validator.constraints.DimensionSizeCheck;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ArraysUtils;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;

public class DimensionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                set.add(8020202);
                set.add(8020204);
                set.add(8020205);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName) {
    }

    ValidationFunction<?> getValidationFunction(int errorCode) {
        Object func = null;
        switch (errorCode) {
            case 8020201: {
                func = new ValidationFunction<Dimension>(){

                    public boolean check(ValidationContext ctx, Dimension c) {
                        return true;
                    }
                };
                break;
            }
            case 8020202: {
                func = new ValidationFunction<Dimension>(){

                    public boolean check(ValidationContext ctx, Dimension c) {
                        DimensionSizeCheck dimSizeCheck = new DimensionSizeCheck(c.getModel(), c);
                        dimSizeCheck.check();
                        if (dimSizeCheck.getListOfErrors().size() > 0) {
                            return !ArraysUtils.checkListOfErrors(dimSizeCheck.getListOfErrors(), 8020202);
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020204: {
                func = new ValidationFunction<Dimension>(){

                    public boolean check(ValidationContext ctx, Dimension c) {
                        DimensionSizeCheck dimSizeCheck = new DimensionSizeCheck(c.getModel(), c);
                        dimSizeCheck.check();
                        if (dimSizeCheck.getListOfErrors().size() > 0) {
                            return !ArraysUtils.checkListOfErrors(dimSizeCheck.getListOfErrors(), 8020204);
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020205: {
                func = new ValidationFunction<Dimension>(){

                    public boolean check(ValidationContext ctx, Dimension c) {
                        DimensionSizeCheck dimSizeCheck = new DimensionSizeCheck(c.getModel(), c);
                        dimSizeCheck.check();
                        if (dimSizeCheck.getListOfErrors().size() > 0) {
                            return !ArraysUtils.checkListOfErrors(dimSizeCheck.getListOfErrors(), 8020205);
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

