/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays;

import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.util.StringTools;

public class Dimension
extends AbstractNamedSBase
implements CallableSBase {
    private static final long serialVersionUID = -2930232424549376654L;
    private String size;
    private int arrayDimension;
    private boolean isSetArrayDimension;

    public Dimension() {
        this.initDefaults();
    }

    public Dimension(String id) {
        super(id);
        this.initDefaults();
    }

    public Dimension(int level, int version) {
        this(null, null, level, version);
    }

    public Dimension(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Dimension(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public Dimension(Dimension obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetSize()) {
            this.setSize(obj.size);
        }
        if (obj.isSetArrayDimension()) {
            this.setArrayDimension(obj.arrayDimension);
        }
    }

    public Dimension clone() {
        return new Dimension(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "arrays";
        this.arrayDimension = -1;
        this.isSetArrayDimension = false;
        this.size = null;
    }

    public boolean isIdMandatory() {
        return false;
    }

    public String getSize() {
        if (this.isSetSize()) {
            return this.size;
        }
        throw new PropertyUndefinedError("size", (SBase)this);
    }

    public boolean isSetSize() {
        return this.size != null;
    }

    public void setSize(String size) {
        String oldSize = this.size;
        this.size = size;
        this.firePropertyChange("size", oldSize, this.size);
    }

    public boolean unsetSize() {
        if (this.isSetSize()) {
            String oldSize = this.size;
            this.size = null;
            this.firePropertyChange("size", oldSize, this.size);
            return true;
        }
        return false;
    }

    public int getArrayDimension() {
        if (this.isSetArrayDimension()) {
            return this.arrayDimension;
        }
        throw new PropertyUndefinedError("arrayDimension", (SBase)this);
    }

    public boolean isSetArrayDimension() {
        return this.isSetArrayDimension;
    }

    public void setArrayDimension(int arrayDimension) {
        int oldArrayDimension = this.arrayDimension;
        this.arrayDimension = arrayDimension;
        this.isSetArrayDimension = true;
        this.firePropertyChange("arrayDimension", oldArrayDimension, this.arrayDimension);
    }

    public boolean unsetArrayDimension() {
        if (this.isSetArrayDimension()) {
            int oldArrayDimension = this.arrayDimension;
            this.arrayDimension = -1;
            this.isSetArrayDimension = false;
            this.firePropertyChange("arrayDimension", oldArrayDimension, this.arrayDimension);
            return true;
        }
        return false;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("arrayDimension")) {
                this.setArrayDimension(StringTools.parseSBMLInt((String)value));
            } else if (attributeName.equals("size")) {
                this.setSize(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("arrays:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("arrays:name", this.getName());
        }
        if (this.isSetArrayDimension()) {
            attributes.remove("arrayDimension");
            attributes.put("arrays:arrayDimension", "" + this.getArrayDimension());
        }
        if (this.isSetSize()) {
            attributes.remove("size");
            attributes.put("arrays:size", this.getSize());
        }
        return attributes;
    }

    public int hashCode() {
        int prime = 2707;
        int result = super.hashCode();
        result = 2707 * result + this.arrayDimension;
        result = 2707 * result + (this.size == null ? 0 : this.size.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Dimension other = (Dimension)((Object)obj);
        if (this.arrayDimension != other.arrayDimension) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    public boolean containsUndeclaredUnits() {
        if (this.isSetSize()) {
            Parameter param = this.getModel().getParameter(this.size);
            return param != null ? param.containsUndeclaredUnits() : false;
        }
        return false;
    }

    public UnitDefinition getDerivedUnitDefinition() {
        if (this.isSetSize()) {
            Parameter param = this.getModel().getParameter(this.size);
            return param != null ? param.getDerivedUnitDefinition() : null;
        }
        return null;
    }

    public String getDerivedUnits() {
        if (this.isSetSize()) {
            Parameter param = this.getModel().getParameter(this.size);
            return param != null ? param.getDerivedUnits() : null;
        }
        return null;
    }
}

