/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.compiler;

import java.util.ArrayList;
import java.util.List;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Quantity;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.Variable;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;

public class StaticallyComputableCompiler
implements ASTNodeCompiler {
    private final Model model;
    private List<String> constantIds;
    boolean isSetConstantIds;

    public StaticallyComputableCompiler(Model model) {
        this.model = model;
    }

    public void addConstantId(String id) {
        if (!this.isSetConstantIds) {
            this.constantIds = new ArrayList<String>();
        }
        this.constantIds.add(id);
        this.isSetConstantIds = true;
    }

    public boolean removeConstantId(String id) {
        if (this.isSetConstantIds) {
            boolean success = this.constantIds.remove(id);
            if (this.constantIds.isEmpty()) {
                this.isSetConstantIds = false;
            }
            return success;
        }
        return false;
    }

    public ASTNodeValue abs(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue and(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue arccos(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arccosh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arccot(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arccoth(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arccsc(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arccsch(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arcsec(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arcsech(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arcsin(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arcsinh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arctan(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue arctanh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue ceiling(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(Compartment c) {
        return new ASTNodeValue(c.isConstant(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(double mantissa, int exponent, String units) {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(double real, String units) {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(int integer, String units) {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(CallableSBase variable) throws SBMLException {
        if (variable instanceof Variable) {
            Variable var = (Variable)variable;
            return new ASTNodeValue(var.isConstant(), (ASTNodeCompiler)this);
        }
        if (variable instanceof Quantity) {
            return new ASTNodeValue(true, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue compile(String name) {
        NamedSBase sbase = this.model.findNamedSBase(name);
        if (sbase != null) {
            if (sbase instanceof Variable) {
                Variable var = (Variable)sbase;
                return new ASTNodeValue(var.getConstant(), (ASTNodeCompiler)this);
            }
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        if (this.isSetConstantIds && this.constantIds.contains(name)) {
            return new ASTNodeValue(true, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(false, (ASTNodeCompiler)this);
    }

    public ASTNodeValue cos(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue cosh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue cot(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue coth(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue csc(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue csch(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue delay(String delayName, ASTNode x, ASTNode delay, String timeUnits) throws SBMLException {
        return delay.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue eq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue exp(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue factorial(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue floor(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue frac(ASTNode numerator, ASTNode denominator) throws SBMLException {
        ASTNodeValue numNode = numerator.compile((ASTNodeCompiler)this);
        ASTNodeValue denNode = denominator.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(numNode.toBoolean() && denNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue frac(int numerator, int denominator) throws SBMLException {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue function(FunctionDefinition functionDefinition, List<ASTNode> args) throws SBMLException {
        for (ASTNode value : args) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue function(String functionDefinitionName, List<ASTNode> args) throws SBMLException {
        for (ASTNode value : args) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue geq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantAvogadro(String name) {
        return this.compile(name);
    }

    public ASTNodeValue getConstantE() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantFalse() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantPi() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantTrue() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getNegativeInfinity() throws SBMLException {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getPositiveInfinity() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue gt(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue lambda(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue leq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue ln(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue log(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue log(ASTNode base, ASTNode value) throws SBMLException {
        ASTNodeValue baseNode = base.compile((ASTNodeCompiler)this);
        ASTNodeValue valueNode = value.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(baseNode.toBoolean() && valueNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue lt(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue minus(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue neq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftNode = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightNode = right.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(leftNode.toBoolean() && rightNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue not(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue or(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue piecewise(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue plus(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue pow(ASTNode base, ASTNode exponent) throws SBMLException {
        ASTNodeValue baseNode = base.compile((ASTNodeCompiler)this);
        ASTNodeValue expNode = exponent.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(baseNode.toBoolean() && expNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue root(ASTNode rootExponent, ASTNode radiant) throws SBMLException {
        ASTNodeValue rootNode = rootExponent.compile((ASTNodeCompiler)this);
        ASTNodeValue radiantNode = radiant.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(rootNode.toBoolean() && radiantNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue root(double rootExponent, ASTNode radiant) throws SBMLException {
        ASTNodeValue radiantNode = radiant.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(radiantNode.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue sec(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue sech(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue selector(List<ASTNode> nodes) throws SBMLException {
        for (int i = 1; i < nodes.size(); ++i) {
            ASTNode value = nodes.get(i);
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue sin(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue sinh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue sqrt(ASTNode radiant) throws SBMLException {
        return radiant.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue symbolTime(String time) {
        return new ASTNodeValue(false, (ASTNodeCompiler)this);
    }

    public ASTNodeValue tan(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue tanh(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue times(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue uMinus(ASTNode value) throws SBMLException {
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue unknownValue() throws SBMLException {
        return new ASTNodeValue(false, (ASTNodeCompiler)this);
    }

    public ASTNodeValue vector(List<ASTNode> nodes) throws SBMLException {
        for (ASTNode value : nodes) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue xor(List<ASTNode> values) throws SBMLException {
        for (ASTNode value : values) {
            ASTNodeValue result = value.compile((ASTNodeCompiler)this);
            if (result.toBoolean()) continue;
            return new ASTNodeValue(false, (ASTNodeCompiler)this);
        }
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue max(List<ASTNode> values) {
        return this.function((String)null, values);
    }

    public ASTNodeValue min(List<ASTNode> values) {
        return this.function((String)null, values);
    }

    public ASTNodeValue quotient(List<ASTNode> values) {
        return this.function((String)null, values);
    }

    public ASTNodeValue rem(List<ASTNode> values) {
        return this.function((String)null, values);
    }

    public ASTNodeValue implies(List<ASTNode> values) {
        return this.function((String)null, values);
    }

    public ASTNodeValue getRateOf(ASTNode nameAST) {
        ArrayList<ASTNode> values = new ArrayList<ASTNode>();
        values.add(nameAST);
        return this.function("rateOf", values);
    }
}

