/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.InitialAssignment;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Quantity;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.util.ArraysMath;
import org.sbml.jsbml.util.Maths;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;

public class VectorCompiler
implements ASTNodeCompiler {
    private final ASTNodeValue dummy = new ASTNodeValue("dummy", null);
    private final Model model;
    private ASTNode node;
    private Map<String, ASTNode> idToVector;
    private boolean isSetIdToVector;
    private boolean useId;
    private NamedSBase sbase;

    public VectorCompiler(Model model) {
        this.model = model;
        this.node = new ASTNode();
        this.useId = false;
        this.isSetIdToVector = false;
    }

    public VectorCompiler(Model model, boolean useId) {
        this.model = model;
        this.node = new ASTNode();
        this.useId = useId;
        this.isSetIdToVector = false;
    }

    public VectorCompiler(Model model, NamedSBase sbase, boolean useId) {
        this.model = model;
        this.node = new ASTNode();
        this.useId = useId;
        this.sbase = sbase;
        this.isSetIdToVector = false;
    }

    public VectorCompiler(Model model, boolean useId, Map<String, ASTNode> idToVector) {
        this.model = model;
        this.node = new ASTNode();
        this.useId = useId;
        this.idToVector = idToVector;
        this.isSetIdToVector = idToVector != null;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public void setNode(ASTNode node) {
        this.node = node;
    }

    public void setIdToVector(Map<String, ASTNode> idToVector) {
        this.idToVector = idToVector;
        this.isSetIdToVector = idToVector != null;
    }

    public void clearIdToVector() {
        this.idToVector.clear();
        this.isSetIdToVector = false;
    }

    public boolean isSetIdToVector() {
        return this.idToVector != null && this.isSetIdToVector;
    }

    public ASTNodeValue abs(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.absRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ABS, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.abs(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void absRecursive(ASTNode value) throws SBMLException {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.absRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode absValue = new ASTNode(ASTNode.Type.FUNCTION_ABS, child.getParentSBMLObject());
                absValue.addChild(child.clone());
                value.replaceChild(i, absValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.abs(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue and(List<ASTNode> values) throws SBMLException {
        ArrayList<ASTNode> vectors = new ArrayList<ASTNode>();
        ArrayList<ASTNode> scalars = new ArrayList<ASTNode>();
        ArrayList<ASTNode> ids = new ArrayList<ASTNode>();
        boolean success = this.getScalarsAndVectors(values, vectors, scalars, ids);
        if (!success) {
            this.unknownValue();
            return this.dummy;
        }
        boolean isSetSumScalar = false;
        boolean hasIds = false;
        if (scalars.size() > 0) {
            isSetSumScalar = true;
        }
        if (ids.size() > 0) {
            hasIds = true;
        }
        boolean scalarResult = true;
        for (ASTNode node : scalars) {
            scalarResult &= node.getReal() == 1.0;
        }
        double sumScalar = scalarResult ? 1.0 : 0.0;
        ASTNode out = new ASTNode(sumScalar);
        if (!vectors.isEmpty()) {
            out = ((ASTNode)vectors.get(0)).clone();
            try {
                this.andRecursive(vectors, out);
            }
            catch (IndexOutOfBoundsException e) {
                this.unknownValue();
                return this.dummy;
            }
            if (isSetSumScalar) {
                this.scalarVectorAnd(out, new ASTNode(sumScalar));
            }
            if (hasIds) {
                for (ASTNode id : ids) {
                    this.scalarVectorAnd(out, id);
                }
            }
        } else {
            if (hasIds) {
                ASTNode result = new ASTNode(ASTNode.Type.LOGICAL_AND, out.getParentSBMLObject());
                if (!ids.isEmpty()) {
                    for (int i = 0; i < ids.size(); ++i) {
                        result.addChild(((ASTNode)ids.get(i)).clone());
                    }
                }
                out = result;
            }
            if (isSetSumScalar) {
                out.addChild(new ASTNode(sumScalar));
            }
        }
        this.setNode(out);
        return this.dummy;
    }

    private void andRecursive(List<ASTNode> values, ASTNode node) throws IndexOutOfBoundsException {
        if (!node.isVector()) {
            boolean result = true;
            boolean isResultSet = false;
            node.setType(ASTNode.Type.LOGICAL_AND);
            node.getChildren().clear();
            if (values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    ASTNode value = values.get(i);
                    if (value.isNumber()) {
                        if (!isResultSet) {
                            result = value.getInteger() == 1;
                            isResultSet = true;
                            continue;
                        }
                        result &= value.getInteger() == 1;
                        continue;
                    }
                    if (this.useId) {
                        node.addChild(values.get(i).clone());
                        continue;
                    }
                    throw new SBMLException();
                }
                if (isResultSet) {
                    node.addChild(new ASTNode(result ? 1 : 0));
                }
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                value.compile((ASTNodeCompiler)this);
                ASTNode result = this.getNode();
                if (!result.isVector()) continue;
                nodes.add(result.getChild(i));
            }
            this.andRecursive(nodes, node.getChild(i));
        }
    }

    private void scalarVectorAnd(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorAnd(child, scalar);
                continue;
            }
            if (this.useId) {
                ASTNode nodeValue = new ASTNode(ASTNode.Type.LOGICAL_AND, vector.getChild(i).getParentSBMLObject());
                nodeValue.addChild(result.clone());
                nodeValue.addChild(scalar.clone());
                vector.replaceChild(i, nodeValue);
                continue;
            }
            if (result.isNumber()) {
                boolean resBool = result.getReal() == 1.0;
                boolean scalBool = scalar.getReal() == 1.0;
                vector.getChild(i).setValue(resBool & scalBool ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccos(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccosRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOS, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.acos(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccosRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccosRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccosValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOS, child.getParentSBMLObject());
                arccosValue.addChild(child.clone());
                value.replaceChild(i, arccosValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.acos(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccosh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccoshRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else if (this.useId) {
            if (compiled.toString().equals("unknown")) {
                compiled.setName("unknown");
            } else {
                compiled.setName("arccosh(" + compiled.getName() + ")");
            }
        } else if (compiled.isNumber()) {
            compiled.setValue(Maths.arccosh((double)compiled.getReal()));
        } else {
            compiled.setName("unknown");
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccoshRecursive(ASTNode value) throws SBMLException {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccoshRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccoshValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOSH, child.getParentSBMLObject());
                arccoshValue.addChild(child.clone());
                value.replaceChild(i, arccoshValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arccosh((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccot(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccotRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else if (this.useId) {
            if (compiled.toString().equals("unknown")) {
                compiled.setName("unknown");
            } else {
                compiled.setName("arccot(" + compiled.getName() + ")");
            }
        } else if (compiled.isNumber()) {
            compiled.setValue(Maths.arccot((double)compiled.getReal()));
        } else {
            compiled.setName("unknown");
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccotRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccotRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccotValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOT, child.getParentSBMLObject());
                arccotValue.addChild(child.clone());
                value.replaceChild(i, arccotValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arccot((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccoth(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccothRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOTH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arccoth((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccothRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccothRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccothValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCOTH, child.getParentSBMLObject());
                arccothValue.addChild(child.clone());
                value.replaceChild(i, arccothValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arccoth((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccsc(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccscRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCSC, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arccsc((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccscRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccscRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccscValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCSC, child.getParentSBMLObject());
                arccscValue.addChild(child.clone());
                value.replaceChild(i, arccscValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arccsc((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arccsch(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arccschRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCSCH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arccsch((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arccschRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arccschRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arccschValue = new ASTNode(ASTNode.Type.FUNCTION_ARCCSCH, child.getParentSBMLObject());
                arccschValue.addChild(child.clone());
                value.replaceChild(i, arccschValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arccsch((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arcsec(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arcsecRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSEC, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arcsec((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arcsecRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arcsecRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arcsecValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSEC, child.getParentSBMLObject());
                arcsecValue.addChild(child.clone());
                value.replaceChild(i, arcsecValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arcsec((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arcsech(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arcsechRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSECH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arcsech((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arcsechRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arcsechRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arcsechValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSECH, child.getParentSBMLObject());
                arcsechValue.addChild(child.clone());
                value.replaceChild(i, arcsechValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arcsech((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arcsin(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arcsinRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSIN, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.asin(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arcsinRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arcsinRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arcsinValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSIN, child.getParentSBMLObject());
                arcsinValue.addChild(child.clone());
                value.replaceChild(i, arcsinValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.asin(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arcsinh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            this.arcsinhRecursive(compiled);
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSINH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arcsinh((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arcsinhRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arcsinhRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arcsinhValue = new ASTNode(ASTNode.Type.FUNCTION_ARCSINH, child.getParentSBMLObject());
                arcsinhValue.addChild(child.clone());
                value.replaceChild(i, arcsinhValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arcsinh((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arctan(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arctanRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCTAN, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.atan(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arctanRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arctanRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arctanValue = new ASTNode(ASTNode.Type.FUNCTION_ARCTAN, child.getParentSBMLObject());
                arctanValue.addChild(child.clone());
                value.replaceChild(i, arctanValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.atan(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue arctanh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.arctanhRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ARCTANH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.arctanh((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void arctanhRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.arctanhRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode arctanhValue = new ASTNode(ASTNode.Type.FUNCTION_ARCTANH, child.getParentSBMLObject());
                arctanhValue.addChild(child.clone());
                value.replaceChild(i, arctanhValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.arctanh((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue ceiling(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.ceilingRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_CEILING, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.ceil(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void ceilingRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.ceilingRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode ceilValue = new ASTNode(ASTNode.Type.FUNCTION_CEILING, child.getParentSBMLObject());
                ceilValue.addChild(child.clone());
                value.replaceChild(i, ceilValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.ceil(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue compile(Compartment c) {
        if (this.useId) {
            this.transformNamedSBase((SBase)c);
        } else {
            this.transformSBase((SBase)c);
        }
        return this.dummy;
    }

    public ASTNodeValue compile(double mantissa, int exponent, String units) {
        ASTNode node = new ASTNode();
        node.setValue(mantissa, exponent);
        this.setNode(node);
        return this.dummy;
    }

    public ASTNodeValue compile(double real, String units) {
        this.setNode(new ASTNode(real));
        return this.dummy;
    }

    public ASTNodeValue compile(int integer, String units) {
        this.setNode(new ASTNode(integer));
        return this.dummy;
    }

    public ASTNodeValue compile(CallableSBase variable) throws SBMLException {
        if (this.useId) {
            this.transformNamedSBase((SBase)variable);
        } else {
            this.transformSBase((SBase)variable);
        }
        return this.dummy;
    }

    public ASTNodeValue compile(String name) {
        if (this.isSetIdToVector() && this.idToVector.containsKey(name)) {
            this.setNode(this.idToVector.get(name));
        } else {
            NamedSBase sbase = this.model.findNamedSBase(name);
            if (sbase != null) {
                if (this.useId) {
                    if (this.isSetIdToVector() && this.idToVector.containsKey(name)) {
                        this.setNode(this.idToVector.get(name));
                    } else {
                        this.transformNamedSBase((SBase)sbase);
                    }
                } else {
                    this.transformSBase((SBase)sbase);
                }
            } else if (this.sbase != null && this.sbase.getId().equals(name)) {
                if (this.useId) {
                    if (this.isSetIdToVector() && this.idToVector.containsKey(name)) {
                        this.setNode(this.idToVector.get(name));
                    } else {
                        this.transformNamedSBase((SBase)this.sbase);
                    }
                } else {
                    this.transformSBase((SBase)this.sbase);
                }
            } else if (this.useId) {
                this.setNode(new ASTNode(name));
            } else {
                this.unknownValue();
            }
        }
        return this.dummy;
    }

    private void transformNamedSBase(SBase sbase) {
        ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
        if (arraysPlugin == null || arraysPlugin.getDimensionCount() == 0) {
            if (sbase instanceof FunctionDefinition) {
                FunctionDefinition namedSBase = (FunctionDefinition)sbase;
                ASTNode func = new ASTNode(ASTNode.Type.FUNCTION);
                func.setName(namedSBase.getId());
                this.setNode(func);
            } else if (sbase instanceof NamedSBase) {
                NamedSBase namedSBase = (NamedSBase)sbase;
                this.setNode(new ASTNode(namedSBase.getId()));
            } else {
                this.unknownValue();
            }
        } else if (sbase instanceof SpeciesReference) {
            SpeciesReference ref = (SpeciesReference)sbase;
            this.setNode(this.constructVector(arraysPlugin, ref));
        } else if (sbase instanceof NamedSBase) {
            NamedSBase namedSBase = (NamedSBase)sbase;
            this.setNode(this.constructVector(arraysPlugin, namedSBase));
        } else {
            this.unknownValue();
        }
    }

    private ASTNode constructVector(ArraysSBasePlugin arraysPlugin, NamedSBase sbase) {
        String id = sbase.getId();
        Dimension dim = arraysPlugin.getDimensionByArrayDimension(0);
        double size = ArraysMath.getSize(this.model, dim);
        ArrayList<Object> vector = new ArrayList<ASTNode>((int)size);
        int i = 0;
        while ((double)i < size) {
            vector.add(new ASTNode("_" + i));
            ++i;
        }
        this.vector(vector);
        ASTNode vectorNode = this.getNode();
        for (int i2 = 1; i2 < arraysPlugin.getDimensionCount(); ++i2) {
            dim = arraysPlugin.getDimensionByArrayDimension(i2);
            size = ArraysMath.getSize(this.model, dim);
            vector = new ArrayList((int)size);
            int j = 0;
            while ((double)j < size) {
                ASTNode clone = vectorNode.clone();
                this.updateASTNodeName(clone, j);
                vector.add(clone);
                ++j;
            }
            this.vector(vector);
            vectorNode = this.getNode();
        }
        this.updateASTNodeName(vectorNode, id);
        return vectorNode;
    }

    private ASTNode constructVector(ArraysSBasePlugin arraysPlugin, Quantity quantity) {
        double value = quantity.getValue();
        Dimension dim = arraysPlugin.getDimensionByArrayDimension(0);
        Parameter p = this.model.getParameter(dim.getSize());
        double size = p.getValue();
        ArrayList<Object> vector = new ArrayList<ASTNode>((int)size);
        int j = 0;
        while ((double)j < size) {
            vector.add(new ASTNode(value));
            ++j;
        }
        this.vector(vector);
        ASTNode vectorNode = this.getNode();
        for (int i = 1; i < arraysPlugin.getDimensionCount(); ++i) {
            dim = arraysPlugin.getDimensionByArrayDimension(i);
            p = this.model.getParameter(dim.getSize());
            size = p.getValue();
            vector = new ArrayList((int)size);
            int j2 = 0;
            while ((double)j2 < size) {
                vector.add(vectorNode);
                ++j2;
            }
            this.vector(vector);
            vectorNode = this.getNode();
        }
        return vectorNode;
    }

    private ASTNode constructVector(ArraysSBasePlugin arraysPlugin, ASTNode node) {
        Dimension dim = arraysPlugin.getDimensionByArrayDimension(0);
        Parameter p = this.model.getParameter(dim.getSize());
        double size = p.getValue();
        ArrayList<Object> vector = new ArrayList<ASTNode>((int)size);
        int j = 0;
        while ((double)j < size) {
            vector.add(node.clone());
            ++j;
        }
        this.vector(vector);
        ASTNode vectorNode = this.getNode();
        for (int i = 1; i < arraysPlugin.getDimensionCount(); ++i) {
            dim = arraysPlugin.getDimensionByArrayDimension(i);
            p = this.model.getParameter(dim.getSize());
            size = p.getValue();
            vector = new ArrayList((int)size);
            int j2 = 0;
            while ((double)j2 < size) {
                vector.add(vectorNode);
                ++j2;
            }
            this.vector(vector);
            vectorNode = this.getNode();
        }
        return vectorNode;
    }

    public ASTNodeValue cos(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.cosRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_COS, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.cos(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void cosRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.cos(child.getReal()));
                continue;
            }
            if (child.isVector()) {
                this.cosRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode cosValue = new ASTNode(ASTNode.Type.FUNCTION_COS, child.getParentSBMLObject());
                cosValue.addChild(child.clone());
                value.replaceChild(i, cosValue);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue cosh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.coshRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_COSH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.cosh(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void coshRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.cosh(child.getReal()));
                continue;
            }
            if (child.isVector()) {
                this.coshRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode coshValue = new ASTNode(ASTNode.Type.FUNCTION_COSH, child.getParentSBMLObject());
                coshValue.addChild(child.clone());
                value.replaceChild(i, coshValue);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue cot(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.cotRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_COT, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.cot((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void cotRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.cot((double)child.getReal()));
                continue;
            }
            if (child.isVector()) {
                this.cotRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode cotValue = new ASTNode(ASTNode.Type.FUNCTION_COT, child.getParentSBMLObject());
                cotValue.addChild(child.clone());
                value.replaceChild(i, cotValue);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue coth(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.cothRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_COTH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.coth((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void cothRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.cothRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode cothValue = new ASTNode(ASTNode.Type.FUNCTION_COTH, child.getParentSBMLObject());
                cothValue.addChild(child.clone());
                value.replaceChild(i, cothValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.coth((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue csc(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.cscRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_CSC, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.csc((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void cscRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.cscRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode cscValue = new ASTNode(ASTNode.Type.FUNCTION_CSC, child.getParentSBMLObject());
                cscValue.addChild(child.clone());
                value.replaceChild(i, cscValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.csc((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue csch(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.cschRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_CSCH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.csch((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void cschRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.cschRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode cschValue = new ASTNode(ASTNode.Type.FUNCTION_CSCH, child.getParentSBMLObject());
                cschValue.addChild(child.clone());
                value.replaceChild(i, cschValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.csch((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue delay(String delayName, ASTNode x, ASTNode delay, String timeUnits) throws SBMLException {
        this.unknownValue();
        return this.dummy;
    }

    public ASTNodeValue eq(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.eqRecursive(rightCompiled, leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.scalarVectorEq(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorEq(result, leftCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_EQ);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (leftCompiled.isNumber() && rightCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue == (rightValue = rightCompiled.getReal()) ? 1 : 0, left.getParentSBMLObject());
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void eqRecursive(ASTNode right, ASTNode left, ASTNode node) throws IndexOutOfBoundsException, SBMLException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_EQ);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() == right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.eqRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void scalarVectorEq(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorEq(child, scalar);
                continue;
            }
            if (this.useId) {
                vector.replaceChild(i, ASTNode.eq((ASTNode)result, (ASTNode)scalar));
                continue;
            }
            if (result.isNumber() && scalar.isNumber()) {
                vector.getChild(i).setValue(result.getReal() == scalar.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue exp(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.expRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_EXP, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.exp(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void expRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.expRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode expValue = new ASTNode(ASTNode.Type.FUNCTION_EXP, child.getParentSBMLObject());
                expValue.addChild(child.clone());
                value.replaceChild(i, expValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.exp(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue factorial(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.factorialRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_FACTORIAL, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                double result = Maths.factorial((int)compiled.getInteger());
                compiled.setValue(result);
            } else {
                compiled = new ASTNode("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void factorialRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.factorialRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode factValue = new ASTNode(ASTNode.Type.FUNCTION_FACTORIAL, child.getParentSBMLObject());
                factValue.addChild(child.clone());
                value.replaceChild(i, factValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue((double)Maths.factorial((int)child.getInteger()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue floor(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.floorRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_FLOOR, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.floor(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void floorRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.floorRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode floorValue = new ASTNode(ASTNode.Type.FUNCTION_FLOOR, child.getParentSBMLObject());
                floorValue.addChild(child.clone());
                value.replaceChild(i, floorValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.floor(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue frac(ASTNode numerator, ASTNode denominator) throws SBMLException {
        numerator.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        denominator.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.fracRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarFrac(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorFrac(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.DIVIDE);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (leftCompiled.isNumber() && rightCompiled.isNumber()) {
                double leftValue = leftCompiled.getReal();
                double rightValue = rightCompiled.getReal();
                if (rightValue == 0.0) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(leftValue / rightValue);
                    this.setNode(result);
                }
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void fracRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RATIONAL);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (right.getReal() == 0.0) {
                    throw new SBMLException();
                }
                node.setValue(left.getReal() / right.getReal());
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.fracRecursive(left.getChild(i), right.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarFrac(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarGt(child, scalar);
                continue;
            }
            if (this.useId) {
                vector.replaceChild(i, ASTNode.frac((ASTNode)result, (ASTNode)scalar));
                continue;
            }
            if (result.isNumber() && scalar.isNumber()) {
                vector.getChild(i).setValue(result.getReal() / scalar.getReal());
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorFrac(ASTNode scalar, ASTNode vector) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorGt(child, scalar);
                continue;
            }
            if (this.useId) {
                vector.replaceChild(i, ASTNode.frac((ASTNode)scalar, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalar.isNumber() && result.getReal() != 0.0) {
                vector.getChild(i).setValue(scalar.getReal() / result.getReal());
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue frac(int numerator, int denominator) throws SBMLException {
        this.frac(new ASTNode(numerator), new ASTNode(denominator));
        return this.dummy;
    }

    public ASTNodeValue function(FunctionDefinition functionDefinition, List<ASTNode> args) throws SBMLException {
        if (functionDefinition != null) {
            if (this.useId) {
                if (this.isSetIdToVector() && this.idToVector.containsKey(functionDefinition.getId())) {
                    this.setNode(this.idToVector.get(functionDefinition.getId()));
                } else {
                    this.transformNamedSBase((SBase)functionDefinition);
                }
                ASTNode newNode = this.getNode();
                for (ASTNode child : args) {
                    child.compile((ASTNodeCompiler)this);
                    newNode.addChild(this.getNode());
                }
                this.setNode(newNode);
            } else {
                ASTNode math = functionDefinition.getBody();
                if (functionDefinition.getArgumentCount() != args.size()) {
                    throw new SBMLException();
                }
                for (int i = 0; i < functionDefinition.getArgumentCount(); ++i) {
                    ASTNode arg = functionDefinition.getArgument(i);
                    if (!arg.isString()) {
                        throw new SBMLException();
                    }
                    math = this.replaceMath(math, arg.toString(), args.get(i));
                }
                math.compile((ASTNodeCompiler)this);
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    public ASTNodeValue function(String functionDefinitionName, List<ASTNode> args) throws SBMLException {
        FunctionDefinition func = this.model.getFunctionDefinition(functionDefinitionName);
        if (func == null) {
            throw new SBMLException("FunctionDefinition with id ' " + functionDefinitionName + "' cannot be found in the model.");
        }
        this.function(func, args);
        return this.dummy;
    }

    public ASTNodeValue geq(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.geqRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarGeq(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorGeq(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_GEQ);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (rightCompiled.isNumber() && leftCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue >= (rightValue = rightCompiled.getReal()) ? 1 : 0);
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void geqRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_GEQ);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() >= right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.geqRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarGeq(ASTNode vectorLHS, ASTNode scalarRHS) {
        for (int i = 0; i < vectorLHS.getChildCount(); ++i) {
            ASTNode child = vectorLHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarGeq(child, scalarRHS);
                continue;
            }
            if (this.useId) {
                vectorLHS.replaceChild(i, ASTNode.geq((ASTNode)result, (ASTNode)scalarRHS));
                continue;
            }
            if (result.isNumber() && scalarRHS.isNumber()) {
                vectorLHS.getChild(i).setValue(result.getReal() >= scalarRHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorGeq(ASTNode scalarLHS, ASTNode vectorRHS) {
        for (int i = 0; i < vectorRHS.getChildCount(); ++i) {
            ASTNode child = vectorRHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorGeq(child, scalarLHS);
                continue;
            }
            if (this.useId) {
                vectorRHS.replaceChild(i, ASTNode.geq((ASTNode)scalarLHS, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalarLHS.isNumber()) {
                vectorRHS.getChild(i).setValue(result.getReal() >= scalarLHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue getConstantAvogadro(String name) {
        ASTNode avogNode = new ASTNode(ASTNode.Type.REAL);
        avogNode.setValue(Math.pow(6.02214179, Math.pow(10.0, 23.0)));
        this.setNode(avogNode);
        return this.dummy;
    }

    public ASTNodeValue getConstantE() {
        ASTNode eNode = new ASTNode(Math.E);
        eNode.setType(ASTNode.Type.CONSTANT_E);
        this.setNode(eNode);
        return this.dummy;
    }

    public ASTNodeValue getConstantFalse() {
        ASTNode falseNode = new ASTNode(0);
        falseNode.setType(ASTNode.Type.CONSTANT_FALSE);
        this.setNode(falseNode);
        return this.dummy;
    }

    public ASTNodeValue getConstantPi() {
        ASTNode piNode = new ASTNode(Math.PI);
        piNode.setType(ASTNode.Type.CONSTANT_PI);
        this.setNode(piNode);
        return this.dummy;
    }

    public ASTNodeValue getConstantTrue() {
        ASTNode trueNode = new ASTNode(1);
        trueNode.setType(ASTNode.Type.CONSTANT_TRUE);
        this.setNode(trueNode);
        return this.dummy;
    }

    public ASTNodeValue getNegativeInfinity() throws SBMLException {
        this.setNode(new ASTNode(Double.NEGATIVE_INFINITY));
        return this.dummy;
    }

    public ASTNodeValue getPositiveInfinity() {
        this.setNode(new ASTNode(Double.POSITIVE_INFINITY));
        return this.dummy;
    }

    private boolean getScalarsAndVectors(List<ASTNode> values, List<ASTNode> vectors, List<ASTNode> scalars, List<ASTNode> ids) {
        for (ASTNode node : values) {
            node.compile((ASTNodeCompiler)this);
            ASTNode value = this.getNode();
            if (value.isVector()) {
                vectors.add(value);
                continue;
            }
            if (this.useId) {
                if (value.isName() && value.getName().equals("unknown")) {
                    return false;
                }
                ids.add(value);
                continue;
            }
            if (value.isNumber()) {
                scalars.add(value);
                continue;
            }
            if (value.isName()) {
                if (value.getName().equals("unknown")) {
                    return false;
                }
                ids.add(value);
                continue;
            }
            return false;
        }
        return true;
    }

    public ASTNodeValue gt(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.gtRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarGt(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorGt(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_GT);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (rightCompiled.isNumber() && leftCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue > (rightValue = rightCompiled.getReal()) ? 1 : 0);
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void gtRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_GT);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() > right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.gtRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarGt(ASTNode vectorLHS, ASTNode scalarRHS) {
        for (int i = 0; i < vectorLHS.getChildCount(); ++i) {
            ASTNode child = vectorLHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarGt(child, scalarRHS);
                continue;
            }
            if (this.useId) {
                vectorLHS.replaceChild(i, ASTNode.gt((ASTNode)result, (ASTNode)scalarRHS));
                continue;
            }
            if (result.isNumber() && scalarRHS.isNumber()) {
                vectorLHS.getChild(i).setValue(result.getReal() > scalarRHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorGt(ASTNode scalarLHS, ASTNode vectorRHS) {
        for (int i = 0; i < vectorRHS.getChildCount(); ++i) {
            ASTNode child = vectorRHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorGt(child, scalarLHS);
                continue;
            }
            if (this.useId) {
                vectorRHS.replaceChild(i, ASTNode.gt((ASTNode)scalarLHS, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalarLHS.isNumber()) {
                vectorRHS.getChild(i).setValue(result.getReal() <= scalarLHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue lambda(List<ASTNode> values) throws SBMLException {
        if (this.useId) {
            ASTNode value = new ASTNode(ASTNode.Type.LAMBDA);
            for (ASTNode node : values) {
                node.compile((ASTNodeCompiler)this);
                value.addChild(this.getNode());
            }
            this.setNode(value);
        } else {
            values.get(values.size() - 1).compile((ASTNodeCompiler)this);
        }
        return this.dummy;
    }

    public ASTNodeValue leq(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.leqRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarLeq(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorLeq(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_LEQ);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (rightCompiled.isNumber() && leftCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue <= (rightValue = rightCompiled.getReal()) ? 1 : 0);
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void leqRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_LEQ);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() <= right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.leqRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarLeq(ASTNode vectorLHS, ASTNode scalarRHS) {
        for (int i = 0; i < vectorLHS.getChildCount(); ++i) {
            ASTNode child = vectorLHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarLeq(child, scalarRHS);
                continue;
            }
            if (this.useId) {
                vectorLHS.replaceChild(i, ASTNode.leq((ASTNode)result, (ASTNode)scalarRHS));
                continue;
            }
            if (result.isNumber() && scalarRHS.isNumber()) {
                vectorLHS.getChild(i).setValue(result.getReal() <= scalarRHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorLeq(ASTNode scalarLHS, ASTNode vectorRHS) {
        for (int i = 0; i < vectorRHS.getChildCount(); ++i) {
            ASTNode child = vectorRHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorLt(scalarLHS, child);
                continue;
            }
            if (this.useId) {
                vectorRHS.replaceChild(i, ASTNode.leq((ASTNode)scalarLHS, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalarLHS.isNumber()) {
                vectorRHS.getChild(i).setValue(result.getReal() < scalarLHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue ln(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.lnRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_LN, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.log(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void lnRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.lnRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode lnValue = new ASTNode(ASTNode.Type.FUNCTION_LN, child.getParentSBMLObject());
                lnValue.addChild(child.clone());
                value.replaceChild(i, lnValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.log(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue log(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.logRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_LOG, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.log10(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void logRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.logRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode logValue = new ASTNode(ASTNode.Type.FUNCTION_LOG, child.getParentSBMLObject());
                logValue.addChild(child.clone());
                value.replaceChild(i, logValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.log10(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue log(ASTNode base, ASTNode value) throws SBMLException {
        base.compile((ASTNodeCompiler)this);
        ASTNode baseCompiled = this.getNode();
        this.log(baseCompiled);
        baseCompiled = this.getNode();
        value.compile((ASTNodeCompiler)this);
        ASTNode valueCompiled = this.getNode();
        this.log(valueCompiled);
        valueCompiled = this.getNode();
        this.frac(valueCompiled, baseCompiled);
        return this.dummy;
    }

    public ASTNodeValue lt(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.ltRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarLt(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorLt(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_LT);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (rightCompiled.isNumber() && leftCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue < (rightValue = rightCompiled.getReal()) ? 1 : 0);
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void ltRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_LT);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() < right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.ltRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarLt(ASTNode vectorLHS, ASTNode scalarRHS) {
        for (int i = 0; i < vectorLHS.getChildCount(); ++i) {
            ASTNode child = vectorLHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarLt(child, scalarRHS);
                continue;
            }
            if (this.useId) {
                vectorLHS.replaceChild(i, ASTNode.lt((ASTNode)result, (ASTNode)scalarRHS));
                continue;
            }
            if (result.isNumber() && scalarRHS.isNumber()) {
                vectorLHS.getChild(i).setValue(result.getReal() < scalarRHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorLt(ASTNode scalarLHS, ASTNode vectorRHS) {
        for (int i = 0; i < vectorRHS.getChildCount(); ++i) {
            ASTNode child = vectorRHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorLt(scalarLHS, child);
                continue;
            }
            if (this.useId) {
                vectorRHS.replaceChild(i, ASTNode.lt((ASTNode)scalarLHS, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalarLHS.isNumber()) {
                vectorRHS.getChild(i).setValue(result.getReal() >= scalarLHS.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue minus(List<ASTNode> values) throws SBMLException {
        ArrayList<ASTNode> negValues = new ArrayList<ASTNode>();
        if (values.size() > 0) {
            values.get(0).compile((ASTNodeCompiler)this);
            negValues.add(this.getNode());
        }
        for (int i = 1; i < values.size(); ++i) {
            values.get(i).compile((ASTNodeCompiler)this);
            this.uMinus(this.getNode());
            negValues.add(this.getNode());
        }
        this.plus(negValues);
        ASTNode plus = this.getNode();
        this.setNode(plus);
        if (this.useId) {
            ASTNode minus = new ASTNode(ASTNode.Type.MINUS);
            if (plus.getChildCount() > 0) {
                minus.addChild(plus.getChild(0));
                for (int i = 1; i < plus.getChildCount(); ++i) {
                    ASTNode child = plus.getChild(i);
                    if (child.getType() == ASTNode.Type.MINUS && child.getChildCount() == 1) {
                        minus.addChild(child.getChild(0));
                        continue;
                    }
                    if (child.getType() == ASTNode.Type.REAL && child.getMantissa() < 0.0) {
                        child.setValue(-child.getMantissa());
                        minus.addChild(child);
                        continue;
                    }
                    if (child.getType() == ASTNode.Type.REAL_E && child.getMantissa() < 0.0) {
                        child.setValue(-child.getMantissa(), child.getExponent());
                        minus.addChild(child);
                        continue;
                    }
                    if (child.getType() == ASTNode.Type.INTEGER && child.getInteger() < 0) {
                        child.setValue(-child.getInteger());
                        minus.addChild(child);
                        continue;
                    }
                    if (child.getType() == ASTNode.Type.RATIONAL && child.getNumerator() < 0) {
                        child.setValue(-child.getNumerator(), child.getDenominator());
                        minus.addChild(child);
                        continue;
                    }
                    minus.addChild(child);
                }
                this.setNode(minus);
            }
        }
        return this.dummy;
    }

    public ASTNodeValue neq(ASTNode left, ASTNode right) throws SBMLException {
        left.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        right.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.neqRecursive(rightCompiled, leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.scalarVectorNeq(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorNeq(result, leftCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.RELATIONAL_NEQ);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (leftCompiled.isNumber() && rightCompiled.isNumber()) {
                double rightValue;
                double leftValue = leftCompiled.getReal();
                ASTNode result = new ASTNode(leftValue != (rightValue = rightCompiled.getReal()) ? 1 : 0, left.getParentSBMLObject());
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void neqRecursive(ASTNode right, ASTNode left, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.RELATIONAL_NEQ);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                if (left.getReal() != right.getReal()) {
                    node.setValue(1);
                } else {
                    node.setValue(0);
                }
            } else {
                throw new SBMLException();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.neqRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void scalarVectorNeq(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorNeq(child, scalar);
                continue;
            }
            if (this.useId) {
                vector.replaceChild(i, ASTNode.neq((ASTNode)result, (ASTNode)scalar));
                continue;
            }
            if (result.isNumber() && scalar.isNumber()) {
                vector.getChild(i).setValue(result.getReal() != scalar.getReal() ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue not(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.notRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.LOGICAL_NOT, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isBoolean()) {
                compiled.setValue(compiled.getInteger() == 1 ? 0 : 1);
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void notRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.notRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode notValue = new ASTNode(ASTNode.Type.LOGICAL_NOT, child.getParentSBMLObject());
                notValue.addChild(child.clone());
                value.replaceChild(i, notValue);
                continue;
            }
            if (child.isBoolean()) {
                value.getChild(i).setValue(child.getInteger() == 1 ? 0 : 1);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue or(List<ASTNode> values) throws SBMLException {
        ArrayList<ASTNode> vectors = new ArrayList<ASTNode>();
        ArrayList<ASTNode> scalars = new ArrayList<ASTNode>();
        ArrayList<ASTNode> ids = new ArrayList<ASTNode>();
        boolean success = this.getScalarsAndVectors(values, vectors, scalars, ids);
        if (!success) {
            this.unknownValue();
            return this.dummy;
        }
        boolean isSetSumScalar = false;
        boolean hasIds = false;
        if (scalars.size() > 0) {
            isSetSumScalar = true;
        }
        if (ids.size() > 0) {
            hasIds = true;
        }
        boolean scalarResult = false;
        for (ASTNode node : scalars) {
            scalarResult |= node.getReal() == 1.0;
        }
        double sumScalar = scalarResult ? 1.0 : 0.0;
        ASTNode out = new ASTNode(sumScalar);
        if (!vectors.isEmpty()) {
            out = ((ASTNode)vectors.get(0)).clone();
            try {
                this.orRecursive(vectors, out);
            }
            catch (IndexOutOfBoundsException e) {
                this.unknownValue();
                return this.dummy;
            }
            if (isSetSumScalar) {
                this.scalarVectorOr(out, new ASTNode(sumScalar));
            }
            if (hasIds) {
                for (ASTNode id : ids) {
                    this.scalarVectorOr(out, id);
                }
            }
        } else {
            if (hasIds) {
                ASTNode result = new ASTNode(ASTNode.Type.LOGICAL_OR, out.getParentSBMLObject());
                if (!ids.isEmpty()) {
                    for (int i = 0; i < ids.size(); ++i) {
                        result.addChild(((ASTNode)ids.get(i)).clone());
                    }
                }
                out = result;
            }
            if (isSetSumScalar) {
                out.addChild(new ASTNode(sumScalar));
            }
        }
        this.setNode(out);
        return this.dummy;
    }

    private void orRecursive(List<ASTNode> values, ASTNode node) throws IndexOutOfBoundsException {
        if (node.isVector()) {
            boolean result = false;
            boolean isResultSet = false;
            node.setType(ASTNode.Type.LOGICAL_OR);
            node.getChildren().clear();
            if (values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    ASTNode value = values.get(i);
                    if (value.isNumber()) {
                        if (!isResultSet) {
                            result = value.getInteger() == 1;
                            isResultSet = true;
                            continue;
                        }
                        result |= value.getInteger() == 1;
                        continue;
                    }
                    if (this.useId) {
                        node.addChild(values.get(i).clone());
                        continue;
                    }
                    throw new SBMLException();
                }
                if (isResultSet) {
                    node.addChild(new ASTNode(result ? 1 : 0));
                }
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                value.compile((ASTNodeCompiler)this);
                ASTNode result = this.getNode();
                if (!result.isVector()) continue;
                nodes.add(result.getChild(i));
            }
            this.orRecursive(nodes, node.getChild(i));
        }
    }

    private void scalarVectorOr(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorOr(child, scalar);
                continue;
            }
            if (this.useId) {
                ASTNode nodeValue = new ASTNode(ASTNode.Type.LOGICAL_OR, vector.getChild(i).getParentSBMLObject());
                nodeValue.addChild(result.clone());
                nodeValue.addChild(scalar.clone());
                vector.replaceChild(i, nodeValue);
                continue;
            }
            if (result.isNumber()) {
                boolean resBool = result.getReal() == 1.0;
                boolean scalBool = scalar.getReal() == 1.0;
                vector.getChild(i).setValue(resBool | scalBool ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue piecewise(List<ASTNode> values) throws SBMLException {
        boolean isVector = false;
        ArrayList<ASTNode> compiledValues = new ArrayList<ASTNode>();
        ASTNode vector = new ASTNode();
        for (ASTNode value : values) {
            value.compile((ASTNodeCompiler)this);
            ASTNode compiledValue = this.getNode();
            compiledValues.add(compiledValue);
            if (!compiledValue.isVector()) continue;
            isVector = true;
            vector = compiledValue.clone();
        }
        if (isVector) {
            this.piecewiseRecursive(values, vector);
            this.setNode(vector);
        } else {
            int i;
            if (this.useId) {
                ASTNode piecewise = new ASTNode(ASTNode.Type.FUNCTION_PIECEWISE);
                piecewise.getChildren().addAll(compiledValues);
                this.setNode(piecewise);
                return this.dummy;
            }
            for (i = 0; i < compiledValues.size(); i += 2) {
                ASTNode math = values.get(i);
                ASTNode cond = values.get(i + 1);
                if (!cond.isOne()) continue;
                this.setNode(math);
                return this.dummy;
            }
            if (i < compiledValues.size()) {
                this.setNode((ASTNode)compiledValues.get(compiledValues.size() - 1));
                return this.dummy;
            }
        }
        return this.dummy;
    }

    private void piecewiseRecursive(List<ASTNode> values, ASTNode vector) throws SBMLException {
        if (!vector.isVector()) {
            vector.setType(ASTNode.Type.FUNCTION_PIECEWISE);
            vector.getChildren().clear();
            for (ASTNode value : values) {
                vector.addChild(value);
            }
            return;
        }
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ArrayList<ASTNode> children = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                if (value.getChildCount() == 0) {
                    children.add(value.clone());
                    continue;
                }
                if (!value.isVector()) continue;
                if (value.getChildCount() != vector.getChildCount()) {
                    throw new SBMLException();
                }
                children.add(value.getChild(i).clone());
            }
            this.piecewiseRecursive(children, vector.getChild(i));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ASTNodeValue plus(List<ASTNode> values) throws SBMLException {
        vectors = new ArrayList<ASTNode>();
        scalars = new ArrayList<ASTNode>();
        ids = new ArrayList<ASTNode>();
        success = this.getScalarsAndVectors(values, vectors, scalars, ids);
        if (!success) {
            this.unknownValue();
            return this.dummy;
        }
        sumScalar = 0.0;
        isSetSumScalar = false;
        hasIds = false;
        if (scalars.size() > 0) {
            isSetSumScalar = true;
        }
        if (ids.size() > 0) {
            hasIds = true;
        }
        for (Object node : scalars) {
            sumScalar += node.getReal();
        }
        out = new ASTNode(sumScalar);
        if (!vectors.isEmpty()) {
            out = ((ASTNode)vectors.get(0)).clone();
            try {
                this.plusRecursive(vectors, out);
                if (isSetSumScalar) {
                    this.scalarVectorPlus(out, new ASTNode(sumScalar));
                }
                if (!hasIds) ** GOTO lbl48
                for (ASTNode id : ids) {
                    this.scalarVectorPlus(out, id);
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.unknownValue();
                return this.dummy;
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (hasIds) {
                result = new ASTNode(ASTNode.Type.PLUS, out.getParentSBMLObject());
                if (!ids.isEmpty()) {
                    for (i = 0; i < ids.size(); ++i) {
                        result.addChild(((ASTNode)ids.get(i)).clone());
                    }
                }
                out = result;
            }
            if (isSetSumScalar) {
                out.addChild(new ASTNode(sumScalar));
            }
        }
lbl48:
        // 5 sources

        this.setNode(out);
        return this.dummy;
    }

    private void plusRecursive(List<ASTNode> values, ASTNode node) throws IndexOutOfBoundsException, SBMLException {
        if (!node.isVector()) {
            double result = 0.0;
            node.getChildren().clear();
            if (!node.getType().equals((Object)ASTNode.Type.PLUS)) {
                node.setType(ASTNode.Type.PLUS);
            }
            if (values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    ASTNode value = values.get(i);
                    if (value.isNumber()) {
                        result += value.getReal();
                        continue;
                    }
                    if (this.useId) {
                        node.addChild(value.clone());
                        continue;
                    }
                    throw new SBMLException();
                }
                node.addChild(new ASTNode(result));
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                value.compile((ASTNodeCompiler)this);
                ASTNode result = this.getNode();
                if (result.isVector()) {
                    if (result.getChildCount() != node.getChildCount()) {
                        throw new SBMLException();
                    }
                    nodes.add(result.getChild(i));
                    continue;
                }
                throw new SBMLException();
            }
            this.plusRecursive(nodes, node.getChild(i));
        }
    }

    private void scalarVectorPlus(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorPlus(child, scalar);
                continue;
            }
            if (this.useId) {
                ASTNode nodeValue = new ASTNode(ASTNode.Type.PLUS, vector.getChild(i).getParentSBMLObject());
                nodeValue.addChild(result.clone());
                nodeValue.addChild(scalar.clone());
                vector.replaceChild(i, nodeValue);
                continue;
            }
            if (result.isNumber()) {
                vector.getChild(i).setValue(result.getReal() + scalar.getReal());
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue pow(ASTNode base, ASTNode exponent) throws SBMLException {
        base.compile((ASTNodeCompiler)this);
        ASTNode leftCompiled = this.getNode();
        exponent.compile((ASTNodeCompiler)this);
        ASTNode rightCompiled = this.getNode();
        if (leftCompiled.isVector()) {
            if (rightCompiled.isVector()) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.powRecursive(leftCompiled, rightCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (rightCompiled.isNumber() || this.useId) {
                ASTNode result = leftCompiled.clone();
                try {
                    this.vectorScalarPow(result, rightCompiled);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else if (leftCompiled.isNumber() || this.useId) {
            if (rightCompiled.isVector()) {
                ASTNode result = rightCompiled.clone();
                try {
                    this.scalarVectorPow(leftCompiled, result);
                }
                catch (SBMLException e) {
                    this.unknownValue();
                    return this.dummy;
                }
                this.setNode(result);
            } else if (this.useId) {
                if (leftCompiled.toString().equals("unknown") || rightCompiled.toString().equals("unknown")) {
                    this.unknownValue();
                } else {
                    ASTNode result = new ASTNode(ASTNode.Type.FUNCTION_POWER);
                    result.addChild(leftCompiled);
                    result.addChild(rightCompiled);
                    this.setNode(result);
                }
            } else if (rightCompiled.isNumber() && leftCompiled.isNumber()) {
                double leftValue = leftCompiled.getReal();
                double rightValue = rightCompiled.getReal();
                ASTNode result = new ASTNode(Math.pow(leftValue, rightValue));
                this.setNode(result);
            } else {
                this.unknownValue();
            }
        } else {
            this.unknownValue();
        }
        return this.dummy;
    }

    private void powRecursive(ASTNode left, ASTNode right, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            if (this.useId) {
                node.setType(ASTNode.Type.FUNCTION_POWER);
                node.getChildren().clear();
                node.addChild(left);
                node.addChild(right);
            } else if (left.isNumber() && right.isNumber()) {
                node.setValue(Math.pow(left.getReal(), right.getReal()));
            } else {
                this.unknownValue();
            }
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            right.compile((ASTNodeCompiler)this);
            ASTNode rightResult = this.getNode();
            left.compile((ASTNodeCompiler)this);
            ASTNode leftResult = this.getNode();
            if (!rightResult.isVector() || !leftResult.isVector()) {
                throw new SBMLException();
            }
            this.powRecursive(right.getChild(i), left.getChild(i), node.getChild(i));
        }
    }

    private void vectorScalarPow(ASTNode vectorLHS, ASTNode scalarRHS) {
        for (int i = 0; i < vectorLHS.getChildCount(); ++i) {
            ASTNode child = vectorLHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.vectorScalarLt(child, scalarRHS);
                continue;
            }
            if (this.useId) {
                vectorLHS.replaceChild(i, ASTNode.pow((ASTNode)result, (ASTNode)scalarRHS));
                continue;
            }
            if (result.isNumber() && scalarRHS.isNumber()) {
                vectorLHS.getChild(i).setValue(Math.pow(result.getReal(), scalarRHS.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    private void scalarVectorPow(ASTNode scalarLHS, ASTNode vectorRHS) {
        for (int i = 0; i < vectorRHS.getChildCount(); ++i) {
            ASTNode child = vectorRHS.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorLt(scalarLHS, child);
                continue;
            }
            if (this.useId) {
                vectorRHS.replaceChild(i, ASTNode.pow((ASTNode)scalarLHS, (ASTNode)result));
                continue;
            }
            if (result.isNumber() && scalarLHS.isNumber()) {
                vectorRHS.getChild(i).setValue(Math.pow(scalarLHS.getReal(), result.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    private ASTNode replaceMath(ASTNode math, String bvar, ASTNode value) {
        ASTNode clone = math.clone();
        if (math.isString() && math.toString().equals(bvar)) {
            return value.clone();
        }
        this.recursiveReplaceDimensionId(clone, bvar, value);
        return clone;
    }

    private void recursiveReplaceDimensionId(ASTNode math, String bvar, ASTNode value) {
        for (int i = 0; i < math.getChildCount(); ++i) {
            if (math.getChild(i).isString() && math.getChild(i).getName().equals(bvar)) {
                math.replaceChild(i, value);
            }
            this.recursiveReplaceDimensionId(math.getChild(i), bvar, value);
        }
    }

    public ASTNodeValue root(ASTNode rootExponent, ASTNode radiant) throws SBMLException {
        this.frac(new ASTNode(1), rootExponent);
        rootExponent = this.getNode();
        this.pow(rootExponent, radiant);
        return this.dummy;
    }

    public ASTNodeValue root(double rootExponent, ASTNode radiant) throws SBMLException {
        this.root(new ASTNode(rootExponent), radiant);
        return this.dummy;
    }

    public ASTNodeValue sec(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.secRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_SEC, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.sec((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void secRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.secRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode secValue = new ASTNode(ASTNode.Type.FUNCTION_SEC, child.getParentSBMLObject());
                secValue.addChild(child.clone());
                value.replaceChild(i, secValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.sec((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue sech(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.sechRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_SECH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Maths.sech((double)compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void sechRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.sechRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode sechValue = new ASTNode(ASTNode.Type.FUNCTION_SECH, child.getParentSBMLObject());
                sechValue.addChild(child.clone());
                value.replaceChild(i, sechValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Maths.sech((double)child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue selector(List<ASTNode> nodes) throws SBMLException {
        if (nodes.size() > 0) {
            nodes.get(0).compile((ASTNodeCompiler)this);
            ASTNode vector = this.getNode();
            ASTNode selector = new ASTNode(ASTNode.Type.FUNCTION_SELECTOR);
            boolean temp = this.useId;
            this.useId = false;
            boolean useNumber = true;
            for (int i = 1; i < nodes.size(); ++i) {
                nodes.get(i).compile((ASTNodeCompiler)this);
                ASTNode index = this.getNode();
                if (useNumber) {
                    if (!index.isNumber()) {
                        if (this.useId && useNumber) {
                            selector.addChild(vector);
                            selector.addChild(index);
                            useNumber = false;
                            continue;
                        }
                        this.unknownValue();
                        return this.dummy;
                    }
                    int indexValue = (int)index.getReal();
                    vector = vector.getChild(indexValue);
                    continue;
                }
                selector.addChild(index);
            }
            if (useNumber) {
                this.setNode(vector);
            } else {
                this.setNode(selector);
            }
            this.useId = temp;
        }
        return this.dummy;
    }

    public ASTNodeValue sin(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.sinRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_SIN, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.sin(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void sinRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.sinRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode sinValue = new ASTNode(ASTNode.Type.FUNCTION_SIN, child.getParentSBMLObject());
                sinValue.addChild(child.clone());
                value.replaceChild(i, sinValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.sin(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue sinh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.sinhRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_SINH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.sinh(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void sinhRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.sinhRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode sinhValue = new ASTNode(ASTNode.Type.FUNCTION_SINH, child.getParentSBMLObject());
                sinhValue.addChild(child.clone());
                value.replaceChild(i, sinhValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.sinh(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue sqrt(ASTNode radiant) throws SBMLException {
        radiant.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.sqrtRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_ROOT, compiled.getParentSBMLObject());
                    nodeValue.addChild(new ASTNode(2));
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.sqrt(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void sqrtRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.sqrtRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode sqrtValue = new ASTNode(ASTNode.Type.FUNCTION_ROOT, child.getParentSBMLObject());
                sqrtValue.addChild(new ASTNode(2));
                sqrtValue.addChild(child.clone());
                value.replaceChild(i, sqrtValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.sqrt(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue symbolTime(String time) {
        ASTNode node = new ASTNode(ASTNode.Type.NAME_TIME);
        node.setName(time);
        this.setNode(node);
        return this.dummy;
    }

    public ASTNodeValue tan(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.tanRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else if (this.useId) {
            compiled.setName("tanh(" + compiled.getName() + ")");
        } else {
            if (compiled.isNumber()) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_TAN, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            compiled.setName("unknown");
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void tanRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.tanRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode tanValue = new ASTNode(ASTNode.Type.FUNCTION_TAN, child.getParentSBMLObject());
                tanValue.addChild(child.clone());
                value.replaceChild(i, tanValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.tan(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue tanh(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.tanhRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (this.useId) {
                if (compiled.toString().equals("unknown")) {
                    compiled.setName("unknown");
                } else {
                    ASTNode nodeValue = new ASTNode(ASTNode.Type.FUNCTION_TANH, compiled.getParentSBMLObject());
                    nodeValue.addChild(compiled);
                    this.setNode(nodeValue);
                }
                return this.dummy;
            }
            if (compiled.isNumber()) {
                compiled.setValue(Math.tanh(compiled.getReal()));
            } else {
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void tanhRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.tanhRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                ASTNode tanhValue = new ASTNode(ASTNode.Type.FUNCTION_TANH, child.getParentSBMLObject());
                tanhValue.addChild(child.clone());
                value.replaceChild(i, tanhValue);
                continue;
            }
            if (child.isNumber()) {
                value.getChild(i).setValue(Math.tanh(child.getReal()));
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue times(List<ASTNode> values) throws SBMLException {
        ArrayList<ASTNode> vectors = new ArrayList<ASTNode>();
        ArrayList<ASTNode> scalars = new ArrayList<ASTNode>();
        ArrayList<ASTNode> ids = new ArrayList<ASTNode>();
        boolean success = this.getScalarsAndVectors(values, vectors, scalars, ids);
        if (!success) {
            this.unknownValue();
            return this.dummy;
        }
        double sumScalar = 1.0;
        boolean isSetSumScalar = false;
        boolean hasIds = false;
        if (scalars.size() > 0) {
            isSetSumScalar = true;
        }
        if (ids.size() > 0) {
            hasIds = true;
        }
        for (ASTNode node : scalars) {
            sumScalar *= node.getReal();
        }
        ASTNode out = new ASTNode(sumScalar);
        if (!vectors.isEmpty()) {
            out = ((ASTNode)vectors.get(0)).clone();
            try {
                this.timesRecursive(vectors, out);
            }
            catch (IndexOutOfBoundsException e) {
                this.unknownValue();
                return this.dummy;
            }
            if (isSetSumScalar) {
                this.scalarVectorTimes(out, new ASTNode(sumScalar));
            }
            if (hasIds) {
                for (ASTNode id : ids) {
                    this.scalarVectorTimes(out, id);
                }
            }
        } else {
            if (hasIds) {
                ASTNode result = new ASTNode(ASTNode.Type.TIMES, out.getParentSBMLObject());
                if (!ids.isEmpty()) {
                    for (int i = 0; i < ids.size(); ++i) {
                        result.addChild(((ASTNode)ids.get(i)).clone());
                    }
                }
                out = result;
            }
            if (isSetSumScalar) {
                out.addChild(new ASTNode(sumScalar));
            }
        }
        this.setNode(out);
        return this.dummy;
    }

    private void timesRecursive(List<ASTNode> values, ASTNode node) throws IndexOutOfBoundsException {
        if (node.getChildCount() == 0) {
            double result = 1.0;
            node.getChildren().clear();
            node.setType(ASTNode.Type.PLUS);
            if (values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    ASTNode value = values.get(i);
                    if (value.isNumber()) {
                        result *= value.getReal();
                        continue;
                    }
                    if (this.useId) {
                        node.addChild(values.get(i).clone());
                        continue;
                    }
                    throw new SBMLException();
                }
                node.addChild(new ASTNode(result));
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                value.compile((ASTNodeCompiler)this);
                ASTNode result = this.getNode();
                if (!result.isVector()) continue;
                nodes.add(result.getChild(i));
            }
            this.timesRecursive(nodes, node.getChild(i));
        }
    }

    private void scalarVectorTimes(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorTimes(child, scalar);
                continue;
            }
            if (this.useId) {
                ASTNode nodeValue = new ASTNode(ASTNode.Type.TIMES, vector.getChild(i).getParentSBMLObject());
                nodeValue.addChild(result.clone());
                nodeValue.addChild(scalar.clone());
                vector.replaceChild(i, nodeValue);
                continue;
            }
            if (result.isNumber()) {
                vector.getChild(i).setValue(result.getReal() * scalar.getReal());
                continue;
            }
            throw new SBMLException();
        }
    }

    private void transformSBase(SBase sbase) {
        ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
        if (arraysPlugin == null || arraysPlugin.getDimensionCount() == 0) {
            if (sbase instanceof Quantity) {
                Quantity quantity = (Quantity)sbase;
                InitialAssignment assign = this.model.getInitialAssignment(quantity.getId());
                if (assign == null) {
                    this.setNode(new ASTNode(quantity.getValue()));
                } else {
                    assign.getMath().compile((ASTNodeCompiler)this);
                }
            } else {
                this.unknownValue();
            }
        } else if (sbase instanceof Quantity) {
            Quantity quantity = (Quantity)sbase;
            InitialAssignment assign = this.model.getInitialAssignment(quantity.getId());
            if (assign != null) {
                assign.getMath().compile((ASTNodeCompiler)this);
                ASTNode node = this.getNode();
                if (node.isVector()) {
                    return;
                }
                this.setNode(this.constructVector(arraysPlugin, node));
            } else {
                this.setNode(this.constructVector(arraysPlugin, quantity));
            }
        } else {
            this.unknownValue();
        }
    }

    private ASTNode constructVector(ArraysSBasePlugin arraysPlugin, SpeciesReference sbase) {
        SBase parent = sbase.getParentSBMLObject();
        if (parent != null) {
            int j;
            int i;
            if ((parent = parent.getParentSBMLObject()) == null) {
                return this.constructVector(arraysPlugin, (NamedSBase)sbase);
            }
            ArraysSBasePlugin arraysParentPlugin = (ArraysSBasePlugin)parent.getExtension("arrays");
            if (arraysParentPlugin == null || arraysParentPlugin.getDimensionCount() == 0) {
                return this.constructVector(arraysPlugin, (NamedSBase)sbase);
            }
            String id = sbase.getId();
            Dimension dim = arraysParentPlugin.getDimensionByArrayDimension(0);
            double size = ArraysMath.getSize(this.model, dim);
            ArrayList<Object> vector = new ArrayList<ASTNode>((int)size);
            int i2 = 0;
            while ((double)i2 < size) {
                vector.add(new ASTNode("_" + i2));
                ++i2;
            }
            this.vector(vector);
            ASTNode vectorNode = this.getNode();
            for (i = 1; i < arraysPlugin.getDimensionCount(); ++i) {
                dim = arraysPlugin.getDimensionByArrayDimension(i);
                size = ArraysMath.getSize(this.model, dim);
                vector = new ArrayList((int)size);
                j = 0;
                while ((double)j < size) {
                    this.updateASTNodeName(vectorNode.clone(), j);
                    vector.add(vectorNode);
                    ++j;
                }
                this.vector(vector);
                vectorNode = this.getNode();
            }
            for (i = 0; i < arraysParentPlugin.getDimensionCount(); ++i) {
                dim = arraysParentPlugin.getDimensionByArrayDimension(i);
                size = ArraysMath.getSize(this.model, dim);
                vector = new ArrayList((int)size);
                j = 0;
                while ((double)j < size) {
                    ASTNode temp = vectorNode.clone();
                    this.updateASTNodeName(temp, j);
                    vector.add(temp);
                    ++j;
                }
                this.vector(vector);
                vectorNode = this.getNode();
            }
            this.updateASTNodeName(vectorNode, id);
            return vectorNode;
        }
        return this.constructVector(arraysPlugin, (NamedSBase)sbase);
    }

    private void updateASTNodeName(ASTNode node, int value) {
        if (node.isVector()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                ASTNode child = node.getChild(i);
                this.updateASTNodeName(child, value);
            }
        } else if (node.isName()) {
            node.setName("_" + String.valueOf(value) + node.getName());
        } else {
            node.setName("unknown");
        }
    }

    private void updateASTNodeName(ASTNode node, String value) {
        if (node.isVector()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                ASTNode child = node.getChild(i);
                this.updateASTNodeName(child, value);
            }
        } else if (node.isName()) {
            String appendName = node.getName();
            while (this.model.findNamedSBase(value + appendName) != null) {
                appendName = "_" + appendName;
            }
            node.setName(value + appendName);
        } else {
            node.setName("unknown");
        }
    }

    public ASTNodeValue uMinus(ASTNode value) throws SBMLException {
        value.compile((ASTNodeCompiler)this);
        ASTNode compiled = this.getNode();
        if (compiled.isVector()) {
            try {
                this.uMinusRecursive(compiled);
            }
            catch (SBMLException e) {
                this.unknownValue();
                return this.dummy;
            }
        } else {
            if (compiled.equals((Object)new ASTNode("unknown"))) {
                this.unknownValue();
                return this.dummy;
            }
            if (compiled.isNumber()) {
                if (compiled.isInteger()) {
                    compiled.setValue(-value.getInteger());
                } else if (compiled.isRational()) {
                    compiled.setValue(-value.getNumerator(), value.getDenominator());
                } else if (compiled.getType().equals((Object)ASTNode.Type.REAL_E)) {
                    compiled.setValue(-value.getMantissa(), value.getExponent());
                } else {
                    compiled.setValue(-value.getReal());
                }
            } else {
                if (this.useId) {
                    if (compiled.toString().equals("unknown")) {
                        compiled.setName("unknown");
                    } else {
                        ASTNode nodeValue = new ASTNode(ASTNode.Type.MINUS, compiled.getParentSBMLObject());
                        nodeValue.addChild(compiled);
                        this.setNode(nodeValue);
                    }
                    return this.dummy;
                }
                compiled.setName("unknown");
            }
        }
        this.setNode(compiled);
        return this.dummy;
    }

    private void uMinusRecursive(ASTNode value) {
        for (int i = 0; i < value.getChildCount(); ++i) {
            value.getChild(i).compile((ASTNodeCompiler)this);
            ASTNode child = this.getNode();
            if (child.isVector()) {
                this.uMinusRecursive(value.getChild(i));
                continue;
            }
            if (this.useId) {
                value.replaceChild(i, ASTNode.uMinus((ASTNode)child));
                continue;
            }
            if (child.isNumber()) {
                if (child.isInteger()) {
                    value.getChild(i).setValue(-child.getInteger());
                    continue;
                }
                if (child.isRational()) {
                    value.getChild(i).setValue(-child.getNumerator(), child.getDenominator());
                    continue;
                }
                if (child.getType().equals((Object)ASTNode.Type.REAL_E)) {
                    value.getChild(i).setValue(-child.getMantissa(), child.getExponent());
                    continue;
                }
                value.getChild(i).setValue(-child.getReal());
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue unknownValue() throws SBMLException {
        this.setNode(new ASTNode("unknown"));
        return this.dummy;
    }

    public ASTNodeValue vector(List<ASTNode> nodes) throws SBMLException {
        ASTNode vector = new ASTNode();
        vector.setType(ASTNode.Type.VECTOR);
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).compile((ASTNodeCompiler)this);
            ASTNode node = this.getNode();
            if (node.equals((Object)new ASTNode("unknown"))) {
                this.unknownValue();
                return this.dummy;
            }
            vector.addChild(this.getNode());
        }
        this.setNode(vector);
        return this.dummy;
    }

    public ASTNodeValue xor(List<ASTNode> values) throws SBMLException {
        ArrayList<ASTNode> vectors = new ArrayList<ASTNode>();
        ArrayList<ASTNode> scalars = new ArrayList<ASTNode>();
        ArrayList<ASTNode> ids = new ArrayList<ASTNode>();
        boolean success = this.getScalarsAndVectors(values, vectors, scalars, ids);
        if (!success) {
            this.unknownValue();
            return this.dummy;
        }
        double sumScalar = 0.0;
        boolean isSetSumScalar = false;
        boolean hasIds = false;
        if (scalars.size() > 0) {
            isSetSumScalar = true;
            boolean scalarResult = true;
            scalarResult ^= ((ASTNode)scalars.get(0)).getReal() == 1.0;
            for (int i = 1; i < scalars.size(); ++i) {
                scalarResult ^= ((ASTNode)scalars.get(i)).getReal() == 1.0;
            }
            double d = sumScalar = scalarResult ? 1.0 : 0.0;
        }
        if (ids.size() > 0) {
            hasIds = true;
        }
        ASTNode out = new ASTNode(sumScalar);
        if (!vectors.isEmpty()) {
            out = ((ASTNode)vectors.get(0)).clone();
            try {
                this.xorRecursive(vectors, out);
            }
            catch (IndexOutOfBoundsException e) {
                this.unknownValue();
                return this.dummy;
            }
            if (isSetSumScalar) {
                this.scalarVectorXor(out, new ASTNode(sumScalar));
            }
            if (hasIds) {
                for (ASTNode id : ids) {
                    this.scalarVectorXor(out, id);
                }
            }
        } else {
            if (hasIds) {
                ASTNode result = new ASTNode(ASTNode.Type.LOGICAL_XOR, out.getParentSBMLObject());
                if (!ids.isEmpty()) {
                    for (int i = 0; i < ids.size(); ++i) {
                        result.addChild(((ASTNode)ids.get(i)).clone());
                    }
                }
                out = result;
            }
            out.addChild(new ASTNode(sumScalar));
        }
        this.setNode(out);
        return this.dummy;
    }

    private void xorRecursive(List<ASTNode> values, ASTNode node) throws IndexOutOfBoundsException {
        if (!node.isVector()) {
            boolean result = false;
            boolean isResultSet = false;
            node.setType(ASTNode.Type.LOGICAL_XOR);
            node.getChildren().clear();
            if (values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    ASTNode value = values.get(i);
                    if (value.isNumber()) {
                        if (!isResultSet) {
                            result = value.getInteger() == 1;
                            isResultSet = true;
                            continue;
                        }
                        result ^= value.getInteger() == 1;
                        continue;
                    }
                    if (this.useId) {
                        node.addChild(values.get(i).clone());
                        continue;
                    }
                    throw new SBMLException();
                }
                if (isResultSet) {
                    node.addChild(new ASTNode(result ? 1 : 0));
                }
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
            for (ASTNode value : values) {
                value.compile((ASTNodeCompiler)this);
                ASTNode result = this.getNode();
                if (!result.isVector()) continue;
                nodes.add(result.getChild(i));
            }
            this.xorRecursive(nodes, node.getChild(i));
        }
    }

    private void scalarVectorXor(ASTNode vector, ASTNode scalar) {
        for (int i = 0; i < vector.getChildCount(); ++i) {
            ASTNode child = vector.getChild(i);
            child.compile((ASTNodeCompiler)this);
            ASTNode result = this.getNode();
            if (result.isVector()) {
                this.scalarVectorXor(child, scalar);
                continue;
            }
            if (this.useId) {
                ASTNode nodeValue = new ASTNode(ASTNode.Type.LOGICAL_XOR, vector.getChild(i).getParentSBMLObject());
                nodeValue.addChild(result.clone());
                nodeValue.addChild(scalar.clone());
                vector.replaceChild(i, nodeValue);
                continue;
            }
            if (result.isNumber()) {
                boolean resBool = result.getReal() == 1.0;
                boolean scalBool = scalar.getReal() == 1.0;
                vector.getChild(i).setValue(resBool ^ scalBool ? 1 : 0);
                continue;
            }
            throw new SBMLException();
        }
    }

    public ASTNodeValue max(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue min(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue quotient(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue rem(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue implies(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue getRateOf(ASTNode nameAST) {
        return null;
    }
}

