/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.Assignment;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.compiler.ArraysCompiler;
import org.sbml.jsbml.ext.arrays.compiler.StaticallyComputableCompiler;
import org.sbml.jsbml.ext.arrays.compiler.VectorCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;

public class ArraysMath {
    public static boolean evaluateBounds(Map<String, Double> dimensionSizes, ASTNode math, double size) {
        ArraysCompiler compiler = new ArraysCompiler();
        compiler.setidToValue(ArraysMath.getLowerBound(dimensionSizes));
        if (math == null) {
            return false;
        }
        ASTNodeValue mathValue = math.compile((ASTNodeCompiler)compiler);
        if (mathValue.isNumber()) {
            if (mathValue.toDouble() < 0.0 || mathValue.toDouble() >= size) {
                return false;
            }
        } else {
            return false;
        }
        compiler.setidToValue(ArraysMath.getUpperBound(dimensionSizes));
        mathValue = math.compile((ASTNodeCompiler)compiler);
        if (mathValue.isNumber()) {
            return !(mathValue.toDouble() < 0.0) && !(mathValue.toDouble() >= size);
        }
        return false;
    }

    public static boolean evaluateIndexBounds(Model model, Index index) {
        SBase parent = index.getParentSBMLObject().getParentSBMLObject();
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)parent.getExtension("arrays");
        if (index.isSetReferencedAttribute()) {
            String refValue = (String)parent.writeXMLAttributes().get(index.getReferencedAttribute());
            NamedSBase refSBase = model.findNamedSBase(refValue);
            ArraysSBasePlugin refSbasePlugin = (ArraysSBasePlugin)refSBase.getExtension("arrays");
            if (refSbasePlugin == null) {
                return false;
            }
            Dimension dimByArrayDim = refSbasePlugin.getDimensionByArrayDimension(index.getArrayDimension());
            if (dimByArrayDim == null) {
                return false;
            }
            Map<String, Double> dimensionSizes = ArraysMath.getDimensionSizes(model, arraysSBasePlugin);
            for (SBase parents = parent.getParentSBMLObject(); parents != null; parents = parents.getParentSBMLObject()) {
                ArraysSBasePlugin parentArraysSBasePlugin = (ArraysSBasePlugin)parents.getExtension("arrays");
                if (parentArraysSBasePlugin == null) continue;
                dimensionSizes.putAll(ArraysMath.getDimensionSizes(model, parentArraysSBasePlugin));
            }
            Map<String, Double> refSBaseSizes = ArraysMath.getDimensionSizes(model, refSbasePlugin);
            double size = refSBaseSizes.get(dimByArrayDim.getId());
            return ArraysMath.evaluateBounds(dimensionSizes, index.getMath(), size);
        }
        return false;
    }

    public static boolean evaluateIndexBounds(Model model, SBase reference, int arrayDim, ASTNode math, Map<String, Double> dimSizes) {
        ArraysSBasePlugin refSbasePlugin = (ArraysSBasePlugin)reference.getExtension("arrays");
        Dimension dim = refSbasePlugin.getDimensionByArrayDimension(arrayDim);
        if (dim == null) {
            return false;
        }
        Parameter paramSize = model.getParameter(dim.getSize());
        if (paramSize == null) {
            return false;
        }
        double size = paramSize.getValue();
        return ArraysMath.evaluateBounds(dimSizes, math, size);
    }

    public static boolean evaluateIndexBounds(Model model, SBase parent, String refAttribute, ASTNode math, int arrayDim) {
        String refId = (String)parent.writeXMLAttributes().get(refAttribute);
        NamedSBase reference = model.findNamedSBase(refId);
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)parent.getExtension("arrays");
        ArraysSBasePlugin parentArraysSBasePlugin = (ArraysSBasePlugin)parent.getParentSBMLObject().getExtension("arrays");
        ArraysSBasePlugin refSbasePlugin = (ArraysSBasePlugin)reference.getExtension("arrays");
        Dimension dimByArrayDim = refSbasePlugin.getDimensionByArrayDimension(arrayDim);
        if (dimByArrayDim == null) {
            return false;
        }
        Map<String, Double> dimensionSizes = ArraysMath.getDimensionSizes(model, arraysSBasePlugin);
        if (parentArraysSBasePlugin != null) {
            dimensionSizes.putAll(ArraysMath.getDimensionSizes(model, parentArraysSBasePlugin));
        }
        Map<String, Double> refSBaseSizes = ArraysMath.getDimensionSizes(model, refSbasePlugin);
        double size = refSBaseSizes.get(dimByArrayDim.getId());
        return ArraysMath.evaluateBounds(dimensionSizes, math, size);
    }

    public static boolean evaluateSelectorBounds(Model model, MathContainer mathContainer) {
        ASTNode math = mathContainer.getMath();
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)mathContainer.getExtension("arrays");
        Map<String, Double> dimensionSizes = ArraysMath.getDimensionSizes(model, arraysSBasePlugin);
        for (SBase parent = mathContainer.getParentSBMLObject(); parent != null; parent = parent.getParentSBMLObject()) {
            ArraysSBasePlugin parentArraysSBasePlugin = (ArraysSBasePlugin)parent.getExtension("arrays");
            if (parentArraysSBasePlugin == null) continue;
            dimensionSizes.putAll(ArraysMath.getDimensionSizes(model, parentArraysSBasePlugin));
        }
        if (math.getType() != ASTNode.Type.FUNCTION_SELECTOR) {
            return true;
        }
        ASTNode obj = math.getChild(0);
        if (obj.isString()) {
            boolean result = true;
            NamedSBase sbase = model.findNamedSBase(obj.toString());
            ArraysSBasePlugin plugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
            if (plugin == null) {
                return true;
            }
            int i = 1;
            if (i < math.getChildCount()) {
                ASTNode index = math.getChild(i);
                Dimension dim = plugin.getDimensionByArrayDimension(i - 1);
                Parameter param = model.getParameter(dim.getSize());
                if (param == null) {
                    return false;
                }
                double size = param.getValue();
                return result &= ArraysMath.evaluateBounds(dimensionSizes, index, size);
            }
        } else {
            if (obj.isVector()) {
                boolean result = true;
                Map<Integer, Integer> vectorSizes = ArraysMath.getVectorDimensionSizes(model, obj);
                for (int i = 1; i < math.getChildCount(); ++i) {
                    ASTNode index = math.getChild(i);
                    Integer size = vectorSizes.get(i);
                    if (size == null) {
                        return false;
                    }
                    result &= ArraysMath.evaluateBounds(dimensionSizes, index, size.intValue());
                }
                return result;
            }
            return false;
        }
        return true;
    }

    public static int getSize(Model model, Dimension dimension) {
        if (dimension == null) {
            return 0;
        }
        String sizeRef = dimension.getSize();
        Parameter param = model.getParameter(sizeRef);
        if (param == null || !param.isSetValue()) {
            throw new SBMLException();
        }
        return (int)param.getValue();
    }

    public static Map<String, Double> getDimensionSizes(Model model, ArraysSBasePlugin arraysSBasePlugin) {
        HashMap<String, Double> dimensionValue = new HashMap<String, Double>();
        if (arraysSBasePlugin == null) {
            return dimensionValue;
        }
        for (Dimension dim : arraysSBasePlugin.getListOfDimensions()) {
            Parameter size;
            if (!dim.isSetId() || (size = model.getParameter(dim.getSize())) == null) continue;
            dimensionValue.put(dim.getId(), size.getValue());
        }
        return dimensionValue;
    }

    public static Map<String, Double> getLowerBound(Map<String, Double> dimSizes) {
        HashMap<String, Double> lowerBound = new HashMap<String, Double>();
        for (String id : dimSizes.keySet()) {
            lowerBound.put(id, 0.0);
        }
        return lowerBound;
    }

    public static Map<String, Double> getUpperBound(Map<String, Double> dimSizes) {
        HashMap<String, Double> upperBound = new HashMap<String, Double>();
        for (String id : dimSizes.keySet()) {
            upperBound.put(id, dimSizes.get(id) - 1.0);
        }
        return upperBound;
    }

    public static boolean isStaticallyComputable(Model model, Index index) {
        SBase parent = index.getParentSBMLObject().getParentSBMLObject();
        ArraysSBasePlugin plugin = (ArraysSBasePlugin)parent.getExtension("arrays");
        SBase parents = parent.getParentSBMLObject();
        ArrayList<String> dimensionIds = new ArrayList<String>();
        if (plugin != null) {
            for (Dimension dim : plugin.getListOfDimensions()) {
                if (!dim.isSetId()) continue;
                dimensionIds.add(dim.getId());
            }
        }
        while (parents != null) {
            ArraysSBasePlugin parentArraysSBasePlugin = (ArraysSBasePlugin)parents.getExtension("arrays");
            if (parentArraysSBasePlugin != null) {
                for (Dimension dim : parentArraysSBasePlugin.getListOfDimensions()) {
                    if (!dim.isSetId()) continue;
                    dimensionIds.add(dim.getId());
                }
            }
            parents = parents.getParentSBMLObject();
        }
        return ArraysMath.isStaticallyComputable(model, (MathContainer)index, dimensionIds.toArray(new String[dimensionIds.size()]));
    }

    public static boolean isStaticallyComputable(Model model, MathContainer mathContainer) {
        ArraysSBasePlugin plugin = (ArraysSBasePlugin)mathContainer.getExtension("arrays");
        ArrayList<String> dimensionIds = new ArrayList<String>();
        if (plugin != null) {
            for (Dimension dim : plugin.getListOfDimensions()) {
                if (!dim.isSetId()) continue;
                dimensionIds.add(dim.getId());
            }
        }
        SBase parent = mathContainer.getParentSBMLObject();
        while (parent != null) {
            ArraysSBasePlugin parentArraysSBasePlugin = (ArraysSBasePlugin)parent.getExtension("arrays");
            parent = parent.getParentSBMLObject();
            if (parentArraysSBasePlugin == null) continue;
            for (Dimension dim : parentArraysSBasePlugin.getListOfDimensions()) {
                if (!dim.isSetId()) continue;
                dimensionIds.add(dim.getId());
            }
        }
        if (mathContainer instanceof KineticLaw) {
            KineticLaw law = (KineticLaw)mathContainer;
            for (LocalParameter local : law.getListOfLocalParameters()) {
                if (!local.isSetId()) continue;
                dimensionIds.add(local.getId());
            }
        }
        return ArraysMath.isStaticallyComputable(model, mathContainer, dimensionIds.toArray(new String[dimensionIds.size()]));
    }

    public static boolean isStaticallyComputable(Model model, MathContainer mathContainer, String ... constantIds) {
        ASTNode math;
        StaticallyComputableCompiler compiler = new StaticallyComputableCompiler(model);
        if (constantIds != null) {
            for (String id : constantIds) {
                compiler.addConstantId(id);
            }
        }
        if ((math = mathContainer.getMath()) == null) {
            return true;
        }
        ASTNodeValue value = math.compile((ASTNodeCompiler)compiler);
        return value.toBoolean();
    }

    public static boolean isStaticallyComputable(Model model, ASTNode math, String ... constantIds) {
        StaticallyComputableCompiler compiler = new StaticallyComputableCompiler(model);
        if (constantIds != null) {
            for (String id : constantIds) {
                compiler.addConstantId(id);
            }
        }
        ASTNodeValue value = math.compile((ASTNodeCompiler)compiler);
        return value.toBoolean();
    }

    public static boolean isVectorOperation(ASTNode math) {
        boolean hasVector = false;
        for (int i = 0; i < math.getChildCount(); ++i) {
            if (!math.getChild(i).isVector()) continue;
            hasVector = true;
            break;
        }
        return hasVector;
    }

    public static boolean checkVectorMath(Model model, MathContainer mathContainer) {
        ASTNode math;
        boolean hasVector;
        VectorCompiler compiler = new VectorCompiler(model);
        if (mathContainer.isSetMath() && (hasVector = ArraysMath.isVectorOperation(math = mathContainer.getMath()))) {
            math.compile((ASTNodeCompiler)compiler);
            ASTNode nodeCompiled = compiler.getNode();
            return nodeCompiled.isVector();
        }
        return true;
    }

    public static boolean checkVectorAssignment(Model model, MathContainer mathContainer) {
        ASTNode math;
        boolean hasVector;
        Assignment assignment;
        VectorCompiler compiler = new VectorCompiler(model);
        if (mathContainer instanceof Assignment && (assignment = (Assignment)mathContainer).isSetMath() && (hasVector = ArraysMath.isVectorOperation(math = assignment.getMath()))) {
            math.compile((ASTNodeCompiler)compiler);
            ASTNode nodeCompiled = compiler.getNode();
            if (assignment.isSetVariable()) {
                NamedSBase variable = model.findNamedSBase(assignment.getVariable());
                if (variable == null) {
                    return false;
                }
                Map<Integer, Integer> sizeOfRHS = ArraysMath.getVectorDimensionSizes(model, nodeCompiled);
                Map<Integer, Integer> sizeOfLHS = ArraysMath.getVectorDimensionSizes(model, new ASTNode(assignment.getVariable()));
                if (sizeOfRHS.size() != sizeOfLHS.size()) {
                    return false;
                }
                for (int i = 0; i < sizeOfRHS.size(); ++i) {
                    if (sizeOfRHS.get(i) == sizeOfLHS.get(i)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static Map<Integer, Integer> getVectorDimensionSizes(Model model, ASTNode math) {
        HashMap<Integer, Integer> sizeByLevel = new HashMap<Integer, Integer>();
        ArraysMath.getSizeRecursive(sizeByLevel, model, math, 0);
        return sizeByLevel;
    }

    private static void getSizeRecursive(Map<Integer, Integer> sizeByLevel, Model model, ASTNode node, int level) {
        if (node.isVector()) {
            sizeByLevel.put(level, node.getChildCount());
            if (node.getChildCount() > 0) {
                ASTNode child = node.getChild(0);
                ArraysMath.getSizeRecursive(sizeByLevel, model, child, level + 1);
            }
        } else if (node.isString()) {
            String id = node.toString();
            NamedSBase sbase = model.findNamedSBase(id);
            if (sbase == null) {
                return;
            }
            ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
            if (arraysSBasePlugin == null || !arraysSBasePlugin.isSetListOfDimensions()) {
                return;
            }
            int maxDim = arraysSBasePlugin.getDimensionCount() - 1;
            for (Dimension dim : arraysSBasePlugin.getListOfDimensions()) {
                Parameter p;
                String size = dim.getSize();
                if (size == null || (p = model.getParameter(size)) == null) continue;
                sizeByLevel.put(level + maxDim - dim.getArrayDimension(), (int)p.getValue());
            }
        }
    }

    public static boolean isVectorBalanced(Model model, MathContainer mathContainer) {
        if (model == null || mathContainer == null) {
            return false;
        }
        ASTNode math = mathContainer.getMath();
        if (math.isVector()) {
            Map<Integer, Integer> sizeByLevel = ArraysMath.getVectorDimensionSizes(model, math);
            return ArraysMath.checkSizeRecursive(model, sizeByLevel, math, 0);
        }
        return true;
    }

    private static boolean checkSizeRecursive(Model model, Map<Integer, Integer> sizeByLevel, ASTNode node, int level) {
        if (!sizeByLevel.containsKey(level)) {
            return false;
        }
        int expected = sizeByLevel.get(level);
        if (!node.isVector()) {
            if (node.isString()) {
                String id = node.toString();
                NamedSBase sbase = model.findNamedSBase(id);
                ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
                for (Dimension dim : arraysSBasePlugin.getListOfDimensions()) {
                    String size = dim.getSize();
                    Parameter p = model.getParameter(size);
                    if (p == null) {
                        return false;
                    }
                    int actual = (int)p.getValue();
                    if (expected == actual) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expected != node.getChildCount()) {
            return false;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = node.getChild(i);
            if (ArraysMath.checkSizeRecursive(model, sizeByLevel, child, level + 1)) continue;
            return false;
        }
        return true;
    }
}

