/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.util.ArrayList;
import java.util.List;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLError;
import org.sbml.jsbml.util.Message;

public abstract class ArraysConstraint {
    protected List<SBMLError> listOfErrors;
    protected Model model;

    public ArraysConstraint() {
        this.model = null;
        this.listOfErrors = new ArrayList<SBMLError>();
    }

    public ArraysConstraint(Model model) {
        this.model = model;
        this.listOfErrors = new ArrayList<SBMLError>();
    }

    public abstract void check();

    public List<SBMLError> getListOfErrors() {
        return this.listOfErrors;
    }

    protected void logFailure(int code, int severity, int category, int line, int column, String pkg, String msg, String shortMsg) {
        SBMLError error = new SBMLError();
        error.setCode(code);
        error.setSeverity(SBMLError.SEVERITY.values()[severity].name());
        error.setCategory("");
        error.setLine(line);
        error.setColumn(column);
        error.setPackage(pkg);
        Message message = new Message();
        message.setMessage(msg);
        error.setMessage(message);
        Message shortMessage = new Message();
        message.setMessage(shortMsg);
        error.setShortMessage(shortMessage);
        this.listOfErrors.add(error);
    }
}

