/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.util.ArraysMath;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class ArraysMathCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final MathContainer mathContainer;

    public ArraysMathCheck(Model model, MathContainer mathContainer) {
        super(model);
        this.mathContainer = mathContainer;
    }

    @Override
    public void check() {
        if (this.model == null || this.mathContainer == null || !this.mathContainer.isSetMath()) {
            return;
        }
        List<ASTNode> selectorNodes = this.getSelectorNodes(this.mathContainer);
        for (ASTNode selectorNode : selectorNodes) {
            this.checkSelector(selectorNode);
        }
    }

    private void checkSelector(ASTNode math) {
        String shortMsg;
        ASTNode obj;
        if (math.getChildCount() == 0) {
            String shortMsg2 = "Selector MathML needs more than 1 argument.";
            this.logSelectorInconsistency(shortMsg2);
        }
        if ((obj = math.getChild(0)).isString()) {
            NamedSBase sbase = this.model.findNamedSBase(obj.toString());
            if (sbase == null) {
                String shortMsg3 = MessageFormat.format("The first argument of {0} does not have a valid SIdRef.", math.toString());
                this.logSelectorInconsistency(shortMsg3);
                return;
            }
            ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
            if (arraysSBasePlugin == null || arraysSBasePlugin.getDimensionCount() < math.getChildCount() - 1) {
                shortMsg = MessageFormat.format("Selector number of arguments of {0} is inconsistent .", math.toString());
                this.logSelectorInconsistency(shortMsg);
            }
        } else if (!obj.isVector()) {
            String shortMsg4 = MessageFormat.format("The first argument of a selector object should be a vector or an arrayed object and {0} violates this condition.", math.toString());
            this.logSelectorInconsistency(shortMsg4);
        }
        boolean isStaticComp = ArraysMath.isStaticallyComputable(this.model, this.mathContainer);
        if (!isStaticComp) {
            String shortMsg5 = MessageFormat.format("Selector arguments other than first should either be dimensions id or constant but {0} violates this condition.", math.toString());
            this.logSelectorInconsistency(shortMsg5);
            return;
        }
        boolean isBounded = ArraysMath.evaluateSelectorBounds(this.model, this.mathContainer);
        if (!isBounded) {
            shortMsg = MessageFormat.format("Selector arguments other than first should not go out of bounds but {0} violates this condition.", math.toString());
            this.logSelectorInconsistency(shortMsg);
        }
    }

    private List<ASTNode> getSelectorNodes(MathContainer mathContainer) {
        ASTNode math = mathContainer.getMath();
        ArrayList<ASTNode> listOfNodes = new ArrayList<ASTNode>();
        this.getSelectorNodes(math, listOfNodes);
        return listOfNodes;
    }

    private void getSelectorNodes(ASTNode math, List<ASTNode> listOfNodes) {
        if (math.getType() == ASTNode.Type.FUNCTION_SELECTOR) {
            listOfNodes.add(math);
        }
        for (int i = 0; i < math.getChildCount(); ++i) {
            this.getSelectorNodes(math.getChild(i), listOfNodes);
        }
    }

    private void logMathVectorIrregular(String shortMsg) {
        int code = 8010211;
        int severity = 0;
        int category = 0;
        int line = 0;
        int column = 0;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("ArraysMathCheck.logMathVectorIrregular");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logSelectorInconsistency(String shortMsg) {
        int code = 8010207;
        int severity = 0;
        int category = 0;
        int line = 0;
        int column = 0;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("ArraysMathCheck.logSelectorInconsistency");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

