/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.util.HashSet;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;

public class DimensionIDCheck
extends ArraysConstraint {
    private SBase sbase;

    public DimensionIDCheck(Model model, SBase sbase) {
        super(model);
        this.sbase = sbase;
    }

    @Override
    public void check() {
        HashSet<String> dimensionIds = new HashSet<String>();
        if (this.model == null) {
            return;
        }
        while (this.sbase != null) {
            ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)this.sbase.getExtension("arrays");
            this.sbase = this.sbase.getParentSBMLObject();
            if (arraysSBasePlugin == null) continue;
            for (Dimension dimension : arraysSBasePlugin.getListOfDimensions()) {
                if (!dimension.isSetId()) continue;
                if (dimensionIds.contains(dimension.getId())) {
                    String shortMsg = "";
                    this.logDuplicatedDimensionId(shortMsg);
                    continue;
                }
                dimensionIds.add(dimension.getId());
            }
        }
    }

    private void logDuplicatedDimensionId(String shortMsg) {
        int code = 20103;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = "";
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

