/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class SBaseWithDimensionCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final SBase sbase;

    public SBaseWithDimensionCheck(Model model, SBase sbase) {
        super(model);
        this.sbase = sbase;
    }

    @Override
    public void check() {
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)this.sbase.getExtension("arrays");
        if (arraysSBasePlugin != null && arraysSBasePlugin.isSetListOfDimensions()) {
            String shortMsg = MessageFormat.format(bundle.getString("SBaseWithDimensionCheck.check"), this.sbase.getElementName());
            this.logDimensionError(shortMsg);
        }
    }

    private void logDimensionError(String shortMsg) {
        int code = 8020107;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("SBaseWithDimensionCheck.logDimensionError");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

