/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class ArraysParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(ArraysParser.class);

    public List<String> getNamespaces() {
        return ArraysConstants.namespaces;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            return new ArraysSBasePlugin(sbase);
        }
        return null;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/arrays/version1";
        }
        return null;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "arrays";
    }

    public boolean isRequired() {
        return true;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            SBase sBase = listOf.getParent();
            ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sBase.getPlugin("arrays");
            if (elementName.equals("dimension")) {
                Dimension dimension = new Dimension();
                arraysPlugin.addDimension(dimension);
                return dimension;
            }
            if (elementName.equals("index")) {
                Index index = new Index();
                arraysPlugin.addIndex(index);
                return index;
            }
        } else if (contextObject instanceof SBase) {
            SBase sBase = (SBase)contextObject;
            if (elementName.equals("listOfDimensions")) {
                ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sBase.getPlugin("arrays");
                return arraysPlugin.getListOfDimensions();
            }
            if (elementName.equals("listOfIndices")) {
                ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sBase.getPlugin("arrays");
                return arraysPlugin.getListOfIndices();
            }
        }
        return contextObject;
    }

    public String getShortLabel() {
        return "arrays";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/arrays/version1";
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        String name = xmlObject.getName();
        if (name.equals("listOfIndexs")) {
            xmlObject.setName("listOfIndices");
        }
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

