/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.compiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.Quantity;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.util.Maths;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;

public class ArraysCompiler
implements ASTNodeCompiler {
    private Map<String, Double> idToValue;

    public ArraysCompiler() {
        this.idToValue = new HashMap<String, Double>();
    }

    public ArraysCompiler(ArraysCompiler obj) {
        this.idToValue = new HashMap<String, Double>(obj.idToValue);
    }

    public ArraysCompiler clone() {
        return new ArraysCompiler(this);
    }

    public boolean isSetidToValue() {
        return this.idToValue != null && !this.idToValue.isEmpty();
    }

    public Map<String, Double> getMapIdToValue() {
        if (!this.isSetidToValue()) {
            this.idToValue = new HashMap<String, Double>();
        }
        return this.idToValue;
    }

    public void setidToValue(Map<String, Double> idToValue) {
        this.unsetidToValue();
        this.idToValue = idToValue;
    }

    public boolean unsetidToValue() {
        if (this.isSetidToValue()) {
            this.idToValue = null;
            return true;
        }
        return false;
    }

    public Double addValue(String name, double value) {
        return this.getMapIdToValue().put(name, value);
    }

    public double removeField(String id) {
        if (this.isSetidToValue()) {
            return this.getMapIdToValue().remove(id);
        }
        return -1.0;
    }

    public double getValue(String name) {
        if (this.isSetidToValue()) {
            return this.getMapIdToValue().get(name);
        }
        return -1.0;
    }

    public int getFieldCount() {
        return this.isSetidToValue() ? this.getMapIdToValue().size() : 0;
    }

    public ASTNodeValue abs(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Math.abs(result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue and(List<ASTNode> values) throws SBMLException {
        if (values.size() > 0) {
            boolean result = values.get(0).compile((ASTNodeCompiler)this).toBoolean();
            for (int i = 1; i < values.size(); ++i) {
                result &= values.get(i).compile((ASTNodeCompiler)this).toBoolean();
            }
            return new ASTNodeValue(result, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccos(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.acos(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccosh(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arccosh((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccot(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arccot((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccoth(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arccoth((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccsc(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arccsc((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arccsch(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arccsch((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arcsec(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arcsec((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arcsech(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arcsech((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arcsin(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.asin(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arcsinh(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arcsinh((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arctan(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.atan(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue arctanh(ASTNode value) throws SBMLException {
        ASTNodeValue result = value.compile((ASTNodeCompiler)this);
        if (result.isNumber()) {
            return new ASTNodeValue(Maths.arctanh((double)result.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue ceiling(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.ceil(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue compile(Compartment c) {
        return new ASTNodeValue(c.getValue(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(double mantissa, int exponent, String units) {
        ASTNode value = new ASTNode(mantissa, exponent);
        return value.compile((ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(double real, String units) {
        return new ASTNodeValue(real, (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(int integer, String units) {
        return new ASTNodeValue(integer, (ASTNodeCompiler)this);
    }

    public ASTNodeValue compile(CallableSBase variable) throws SBMLException {
        if (variable instanceof Quantity) {
            Quantity quantity = (Quantity)variable;
            return new ASTNodeValue(quantity.getValue(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue compile(String name) {
        if (this.idToValue.containsKey(name)) {
            return new ASTNodeValue((Number)this.idToValue.get(name), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue cos(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.cos(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue cosh(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.cosh(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue cot(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.cot((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue coth(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.coth((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue csc(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.csc((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue csch(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.csch((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue delay(String delayName, ASTNode x, ASTNode delay, String timeUnits) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue eq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() == rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue exp(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.exp(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue factorial(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.factorial((int)nodeValue.toInteger()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue floor(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.floor(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue frac(ASTNode numerator, ASTNode denominator) throws SBMLException {
        ASTNodeValue numValue = numerator.compile((ASTNodeCompiler)this);
        ASTNodeValue demValue = denominator.compile((ASTNodeCompiler)this);
        if (numerator.isNumber() && denominator.isNumber()) {
            return new ASTNodeValue(numValue.toDouble() / demValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue frac(int numerator, int denominator) throws SBMLException {
        return new ASTNodeValue(numerator / denominator, (ASTNodeCompiler)this);
    }

    public ASTNodeValue function(FunctionDefinition functionDefinition, List<ASTNode> args) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue function(String functionDefinitionName, List<ASTNode> args) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue functionCsymbol(ASTNode csymbol) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue geq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() >= rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue getConstantAvogadro(String name) {
        return this.unknownValue();
    }

    public ASTNodeValue getConstantE() {
        return new ASTNodeValue(Math.E, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantFalse() {
        return new ASTNodeValue(false, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantPi() {
        return new ASTNodeValue(Math.PI, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getConstantTrue() {
        return new ASTNodeValue(true, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getNegativeInfinity() throws SBMLException {
        return new ASTNodeValue(Double.NEGATIVE_INFINITY, (ASTNodeCompiler)this);
    }

    public ASTNodeValue getPositiveInfinity() {
        return new ASTNodeValue(Double.POSITIVE_INFINITY, (ASTNodeCompiler)this);
    }

    public ASTNodeValue gt(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() > rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue lambda(List<ASTNode> values) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue leq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() <= rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue ln(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.log(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue log(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.log10(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue log(ASTNode base, ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        ASTNodeValue nodeBase = base.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber() && nodeBase.isNumber()) {
            return new ASTNodeValue(Maths.log((double)nodeValue.toDouble(), (double)nodeBase.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue lt(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() < rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue minus(List<ASTNode> values) throws SBMLException {
        double result = 0.0;
        if (values.size() > 0) {
            ASTNodeValue astNodeValue = values.get(0).compile((ASTNodeCompiler)this);
            result = astNodeValue.toDouble();
        }
        for (int i = 1; i < values.size(); ++i) {
            ASTNodeValue astNodeValue = values.get(i).compile((ASTNodeCompiler)this);
            result -= astNodeValue.toDouble();
        }
        return new ASTNodeValue(result, (ASTNodeCompiler)this);
    }

    public ASTNodeValue neq(ASTNode left, ASTNode right) throws SBMLException {
        ASTNodeValue leftValue = left.compile((ASTNodeCompiler)this);
        ASTNodeValue rightValue = right.compile((ASTNodeCompiler)this);
        if (leftValue.isNumber() && rightValue.isNumber()) {
            return new ASTNodeValue(leftValue.toDouble() != rightValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue not(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        return new ASTNodeValue(nodeValue.toBoolean(), (ASTNodeCompiler)this);
    }

    public ASTNodeValue or(List<ASTNode> values) throws SBMLException {
        if (values.size() > 0) {
            boolean result = values.get(0).compile((ASTNodeCompiler)this).toBoolean();
            for (int i = 1; i < values.size(); ++i) {
                result |= values.get(i).compile((ASTNodeCompiler)this).toBoolean();
            }
            return new ASTNodeValue(result, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue piecewise(List<ASTNode> values) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue plus(List<ASTNode> values) throws SBMLException {
        double result = 0.0;
        for (ASTNode value : values) {
            ASTNodeValue astNodeValue = value.compile((ASTNodeCompiler)this);
            if (astNodeValue.isNumber()) {
                result += astNodeValue.toDouble();
                continue;
            }
            return this.unknownValue();
        }
        return new ASTNodeValue(result, (ASTNodeCompiler)this);
    }

    public ASTNodeValue pow(ASTNode base, ASTNode exponent) throws SBMLException {
        ASTNodeValue astNodeBase = base.compile((ASTNodeCompiler)this);
        ASTNodeValue astNodeExp = exponent.compile((ASTNodeCompiler)this);
        if (astNodeBase.isNumber() && astNodeExp.isNumber()) {
            double result = Math.pow(astNodeBase.toDouble(), astNodeExp.toDouble());
            return new ASTNodeValue(result, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue root(ASTNode rootExponent, ASTNode radiant) throws SBMLException {
        ASTNodeValue astNodeRad = radiant.compile((ASTNodeCompiler)this);
        ASTNodeValue astNodeExp = rootExponent.compile((ASTNodeCompiler)this);
        if (astNodeRad.isNumber() && astNodeExp.isNumber()) {
            double result = Maths.root((double)astNodeRad.toDouble(), (double)astNodeExp.toDouble());
            return new ASTNodeValue(result, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue root(double rootExponent, ASTNode radiant) throws SBMLException {
        return this.root(new ASTNode(rootExponent), radiant);
    }

    public ASTNodeValue sec(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.sec((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue sech(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Maths.sech((double)nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue selector(List<ASTNode> nodes) throws SBMLException {
        ASTNode object = nodes.get(0);
        if (object.isVector()) {
            ASTNode result = object;
            for (int i = 1; i < nodes.size(); ++i) {
                int index = (int)nodes.get(i).compile((ASTNodeCompiler)this).toDouble();
                result = result.getChild(index);
            }
            return result.compile((ASTNodeCompiler)this);
        }
        if (object.isVariable()) {
            this.compile(object.getVariable());
        } else if (object.isString()) {
            this.compile(object.getName());
        }
        return this.unknownValue();
    }

    public ASTNodeValue sin(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.sin(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue sinh(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.sinh(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue sqrt(ASTNode radiant) throws SBMLException {
        ASTNodeValue nodeRad = radiant.compile((ASTNodeCompiler)this);
        if (nodeRad.isNumber()) {
            return new ASTNodeValue(Math.sqrt(nodeRad.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue symbolTime(String time) {
        if (this.idToValue.containsKey(time)) {
            return new ASTNodeValue((Number)this.idToValue.get(time), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue tan(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.tan(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue tanh(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(Math.tanh(nodeValue.toDouble()), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue times(List<ASTNode> values) throws SBMLException {
        double result = 0.0;
        if (values.size() > 0) {
            ASTNodeValue astNodeValue = values.get(0).compile((ASTNodeCompiler)this);
            result = astNodeValue.toDouble();
        }
        for (int i = 1; i < values.size(); ++i) {
            ASTNodeValue astNodeValue = values.get(i).compile((ASTNodeCompiler)this);
            result *= astNodeValue.toDouble();
        }
        return new ASTNodeValue(result, (ASTNodeCompiler)this);
    }

    public ASTNodeValue uMinus(ASTNode value) throws SBMLException {
        ASTNodeValue nodeValue = value.compile((ASTNodeCompiler)this);
        if (nodeValue.isNumber()) {
            return new ASTNodeValue(-nodeValue.toDouble(), (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue unknownValue() throws SBMLException {
        return new ASTNodeValue((ASTNodeCompiler)this);
    }

    public ASTNodeValue vector(List<ASTNode> nodes) throws SBMLException {
        return this.unknownValue();
    }

    public ASTNodeValue xor(List<ASTNode> values) throws SBMLException {
        if (values.size() > 0) {
            boolean result = values.get(0).compile((ASTNodeCompiler)this).toBoolean();
            for (int i = 1; i < values.size(); ++i) {
                result ^= values.get(i).compile((ASTNodeCompiler)this).toBoolean();
            }
            return new ASTNodeValue(result, (ASTNodeCompiler)this);
        }
        return this.unknownValue();
    }

    public ASTNodeValue max(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue min(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue quotient(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue rem(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue implies(List<ASTNode> values) {
        return null;
    }

    public ASTNodeValue getRateOf(ASTNode name) {
        return null;
    }
}

