/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.flattening;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.compiler.ArraysCompiler;
import org.sbml.jsbml.ext.arrays.compiler.VectorCompiler;
import org.sbml.jsbml.ext.arrays.util.ArraysMath;
import org.sbml.jsbml.ext.comp.Port;
import org.sbml.jsbml.ext.comp.SBaseRef;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;

public class ArraysFlattening {
    private static final ASTNode unknown = new ASTNode("unknown");
    private static final transient Logger logger = Logger.getLogger(ArraysFlattening.class);

    public static SBMLDocument convert(SBMLDocument document) {
        try {
            SBMLDocument flattenedDoc = document.clone();
            Model model = flattenedDoc.getModel();
            HashMap<String, ASTNode> idToVector = new HashMap<String, ASTNode>();
            ArraysFlattening.getVectors((SBase)flattenedDoc.getModel(), idToVector);
            ArraysFlattening.convert(flattenedDoc, model, new ArraysCompiler(), idToVector, new ArrayList<Integer>());
            ArraysFlattening.convertMath(flattenedDoc, model, idToVector);
            return flattenedDoc;
        }
        catch (SBMLException exception) {
            logger.error((Object)exception.getMessage());
            return null;
        }
    }

    private static void addToParent(Model model, SBase parent, SBase child) {
        if (parent == null) {
            throw new SBMLException(MessageFormat.format("Could not add SBase {0} a null parent. Flattening Failed.", child));
        }
        if (parent instanceof ListOf) {
            ListOf parentList = (ListOf)parent;
            try {
                parentList.add(child);
            }
            catch (IllegalArgumentException exception) {
                throw new SBMLException(MessageFormat.format("Could not add SBase {0} because this object has an id that is already present in the model. Flattening Failed.", child));
            }
            return;
        }
        if (parent instanceof Port && child instanceof SBaseRef) {
            Port port = (Port)parent;
            port.setSBaseRef((SBaseRef)child);
            return;
        }
        throw new SBMLException(MessageFormat.format("Could not add SBase {0} to the model because {1} does not have the correct type (ListOf).", child, parent));
    }

    private static void convert(Model model, TreeNode node, ArraysCompiler compiler, Map<String, ASTNode> idToVector, List<Integer> indices) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            TreeNode child = node.getChildAt(i);
            boolean isExpanded = ArraysFlattening.expandDim(model, child, compiler.clone(), idToVector, indices);
            if (isExpanded) continue;
            ArraysFlattening.convert(model, child, compiler, idToVector, indices);
        }
    }

    private static void convert(SBMLDocument doc, Model model, ArraysCompiler compiler, Map<String, ASTNode> idToVector, List<Integer> indices) {
        for (int i = doc.getChildCount() - 1; i >= 0; --i) {
            TreeNode child = doc.getChildAt(i);
            ArraysFlattening.convert(model, child, compiler, idToVector, indices);
        }
    }

    private static void convertArraysMath(Model model, TreeNode child, Map<String, ASTNode> idToVector) {
        if (child instanceof MathContainer) {
            VectorCompiler compiler = new VectorCompiler(model, true, idToVector);
            MathContainer mathContainer = (MathContainer)child;
            if (mathContainer.isSetMath()) {
                mathContainer.getMath().compile((ASTNodeCompiler)compiler);
                ASTNode math = compiler.getNode();
                if (!math.equals((Object)unknown)) {
                    try {
                        mathContainer.setMath(math);
                    }
                    catch (SBMLException e) {
                        throw new SBMLException(MessageFormat.format("The math of the object {0} could not be evaluated. Flattening Failed.", mathContainer));
                    }
                }
            }
        }
    }

    private static void convertIndex(Model model, ArraysSBasePlugin arraysPlugin, SBase sbase, ArraysCompiler compiler, Map<String, ASTNode> idToVector, List<Integer> indices) {
        if (arraysPlugin.getIndexCount() < 1) {
            return;
        }
        int maxIndex = -1;
        HashSet<String> attributes = new HashSet<String>();
        for (Index index : arraysPlugin.getListOfIndices()) {
            if (index.isSetArrayDimension() && index.getArrayDimension() > maxIndex) {
                maxIndex = index.getArrayDimension();
            }
            if (!index.isSetReferencedAttribute() || attributes.contains(index.getReferencedAttribute())) continue;
            attributes.add(index.getReferencedAttribute());
        }
        for (String attribute : attributes) {
            String indexValue = ArraysFlattening.getIndexedId(arraysPlugin, sbase, attribute, maxIndex, compiler, idToVector, indices);
            String[] parse = attribute.split(":");
            if (parse.length == 2) {
                sbase.readAttribute(parse[1], parse[0], indexValue);
                continue;
            }
            sbase.readAttribute(attribute, "", indexValue);
        }
    }

    private static void convertMath(Model model, TreeNode node, Map<String, ASTNode> idToVector) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            TreeNode child = node.getChildAt(i);
            ArraysFlattening.convertArraysMath(model, child, idToVector);
            ArraysFlattening.convertMath(model, child, idToVector);
        }
    }

    private static void convertMath(SBMLDocument doc, Model model, Map<String, ASTNode> idToVector) {
        for (int i = doc.getChildCount() - 1; i >= 0; --i) {
            TreeNode child = doc.getChildAt(i);
            ArraysFlattening.convertMath(model, child, idToVector);
        }
    }

    private static void expandDim(Model model, NamedSBase sbase, SBase parent, ArraysSBasePlugin arraysPlugin, ArraysCompiler compiler, ASTNode vector, int dim, Map<String, ASTNode> idToVector, List<Integer> indices) {
        Dimension dimension = arraysPlugin.getDimensionByArrayDimension(dim);
        if (dimension == null) {
            sbase.unsetExtension("arrays");
            if (sbase.isSetId() && vector != null && vector.isName()) {
                sbase.setId(vector.getName());
            }
            ArraysFlattening.convertIndex(model, arraysPlugin, (SBase)sbase, compiler, idToVector, indices);
            for (int i = sbase.getChildCount() - 1; i >= 0; --i) {
                ArraysFlattening.convert(model, sbase.getChildAt(i), compiler.clone(), idToVector, indices);
            }
            ArraysFlattening.addToParent(model, parent, (SBase)sbase);
            return;
        }
        int size = ArraysMath.getSize(model, dimension);
        for (int i = 0; i < size; ++i) {
            NamedSBase clone = (NamedSBase)sbase.clone();
            ASTNode nodeCopy = vector.clone();
            nodeCopy = nodeCopy.getChild(i);
            ArraysFlattening.updateSBase(model.getSBMLDocument(), arraysPlugin, (SBase)clone, i);
            ArraysFlattening.updateMath((SBase)clone, dimension.getId(), i);
            compiler.addValue(dimension.getId(), i);
            ArrayList<Integer> cloneIndices = new ArrayList<Integer>(indices);
            cloneIndices.add(i);
            ArraysFlattening.expandDim(model, clone, parent, arraysPlugin, compiler.clone(), nodeCopy, dim - 1, idToVector, cloneIndices);
        }
    }

    private static void expandDim(Model model, SBase sbase, SBase parent, ArraysSBasePlugin arraysPlugin, ArraysCompiler compiler, int dim, Map<String, ASTNode> idToVector, List<Integer> indices) {
        Dimension dimension = arraysPlugin.getDimensionByArrayDimension(dim);
        if (dimension == null) {
            sbase.unsetExtension("arrays");
            ArraysFlattening.convertIndex(model, arraysPlugin, sbase, compiler, idToVector, indices);
            for (int i = sbase.getChildCount() - 1; i >= 0; --i) {
                ArraysFlattening.convert(model, sbase.getChildAt(i), compiler.clone(), idToVector, indices);
            }
            ArraysFlattening.addToParent(model, parent, sbase);
            return;
        }
        int size = ArraysMath.getSize(model, dimension);
        for (int i = 0; i < size; ++i) {
            SBase clone = sbase.clone();
            ArraysFlattening.updateSBase(model.getSBMLDocument(), arraysPlugin, clone, i);
            ArraysFlattening.updateMath(clone, dimension.getId(), i);
            compiler.addValue(dimension.getId(), i);
            ArrayList<Integer> cloneIndices = new ArrayList<Integer>(indices);
            cloneIndices.add(i);
            ArraysFlattening.expandDim(model, clone, parent, arraysPlugin, compiler.clone(), dim - 1, idToVector, cloneIndices);
        }
    }

    private static boolean expandDim(Model model, TreeNode child, ArraysCompiler compiler, Map<String, ASTNode> idToVector, List<Integer> indices) {
        if (child instanceof SBase) {
            SBase sbase = (SBase)child;
            ArraysSBasePlugin arraysPlugin = (ArraysSBasePlugin)sbase.getExtension("arrays");
            if (arraysPlugin == null) {
                return false;
            }
            int dim = arraysPlugin.getDimensionCount() - 1;
            if (dim < 0) {
                ArraysFlattening.convertIndex(model, arraysPlugin, sbase, compiler, idToVector, indices);
                sbase.unsetExtension("arrays");
                return false;
            }
            if (child instanceof NamedSBase) {
                ArraysFlattening.expandDim(model, (NamedSBase)sbase.clone(), sbase.getParentSBMLObject(), arraysPlugin, compiler, idToVector.get(((NamedSBase)child).getId()), dim, idToVector, indices);
            } else {
                ArraysFlattening.expandDim(model, sbase.clone(), sbase.getParentSBMLObject(), arraysPlugin, compiler, dim, idToVector, indices);
            }
            sbase.removeFromParent();
            return true;
        }
        return false;
    }

    private static String getIndexedId(ArraysSBasePlugin arraysPlugin, SBase sbase, String attribute, int maxIndex, ArraysCompiler compiler, Map<String, ASTNode> idToVector, List<Integer> indices) {
        String temp = (String)sbase.writeXMLAttributes().get(attribute);
        if (temp == null) {
            throw new SBMLException(MessageFormat.format("Unable to get the value of attribute {0} of object {1}. Flattening Failed.", attribute, sbase));
        }
        ASTNode vector = idToVector.get(temp);
        if (vector == null) {
            String append = "";
            for (int i = maxIndex; i >= 0; --i) {
                Index index = arraysPlugin.getIndex(i, attribute);
                if (index == null) {
                    throw new SBMLException(MessageFormat.format("Unable to get index with arrayDimension {0} and referencedAttribute {1}. Flattening Failed.", i, attribute));
                }
                ASTNodeValue value = index.getMath().compile((ASTNodeCompiler)compiler);
                if (!value.isNumber()) {
                    throw new SBMLException(MessageFormat.format("Index math should be evaluated to a scalar, but Index {0} evaluates to a vector. Flattening Failed.", new Object[]{index}));
                }
                append = append + "_" + value.toInteger();
            }
            return temp + append;
        }
        for (int i = maxIndex; i >= 0; --i) {
            Index index = arraysPlugin.getIndex(i, attribute);
            if (index == null) {
                throw new SBMLException(MessageFormat.format("Unable to get index with arrayDimension {0} and referencedAttribute {1}. Flattening Failed.", i, attribute));
            }
            ASTNodeValue value = index.getMath().compile((ASTNodeCompiler)compiler);
            if (!value.isNumber()) {
                throw new SBMLException(MessageFormat.format("Index math should be evaluated to a scalar, but Index {0} evaluates to a vector. Flattening Failed.", new Object[]{index}));
            }
            vector = vector.getChild(value.toInteger());
        }
        if (vector.isName()) {
            return vector.getName();
        }
        int numOfImplicit = indices.size() - arraysPlugin.getDimensionCount();
        for (int i = 0; i < numOfImplicit; ++i) {
            if (vector == null) {
                throw new SBMLException(MessageFormat.format("Could not flatten the value for {0}. Flattening Failed.", temp));
            }
            vector = vector.getChild(indices.get(i).intValue());
        }
        return vector.getName();
    }

    private static void getVectors(SBase sbase, Map<String, ASTNode> ids) {
        for (int i = sbase.getChildCount() - 1; i >= 0; --i) {
            TreeNode node = sbase.getChildAt(i);
            if (node instanceof NamedSBase) {
                NamedSBase namedSbase = (NamedSBase)node;
                ASTNode idMath = new ASTNode(namedSbase.getId());
                VectorCompiler compiler = new VectorCompiler(sbase.getModel(), namedSbase, true);
                idMath.compile((ASTNodeCompiler)compiler);
                idMath = compiler.getNode();
                if (idMath.isVector()) {
                    ids.put(namedSbase.getId(), idMath);
                }
            }
            if (!(node instanceof SBase)) continue;
            ArraysFlattening.getVectors((SBase)node, ids);
        }
    }

    private static void recursiveReplaceDimensionId(ASTNode math, String id, int index) {
        if (math.getChildCount() == 0) {
            if (math.isString() && math.getName().equals(id)) {
                math.setValue(index);
            }
            return;
        }
        for (int i = 0; i < math.getChildCount(); ++i) {
            ArraysFlattening.recursiveReplaceDimensionId(math.getChild(i), id, index);
        }
    }

    private static ASTNode replaceDimensionId(ASTNode math, String id, int index) {
        ASTNode clone = math.clone();
        ArraysFlattening.recursiveReplaceDimensionId(clone, id, index);
        return clone;
    }

    private static void updateMath(SBase sbase, String dimId, int index) {
        if (sbase instanceof MathContainer) {
            MathContainer mathContainer = (MathContainer)sbase;
            if (mathContainer.isSetMath()) {
                mathContainer.setMath(ArraysFlattening.replaceDimensionId(mathContainer.getMath(), dimId, index));
            } else {
                throw new SBMLException(MessageFormat.format("MathContainer {0} does not have a math element associated with it. Flattening Failed.", mathContainer));
            }
        }
        for (int i = sbase.getChildCount() - 1; i >= 0; --i) {
            TreeNode child = sbase.getChildAt(i);
            if (!(child instanceof SBase)) continue;
            ArraysFlattening.updateMath((SBase)child, dimId, index);
        }
    }

    private static void updateSBase(SBMLDocument doc, ArraysSBasePlugin arraysPlugin, SBase sbase, int index) {
        if (sbase.isSetMetaId()) {
            String metaId = sbase.getMetaId();
            String appendId = "_" + index;
            while (doc.findSBase(metaId + appendId) != null) {
                appendId = "_" + appendId;
            }
            sbase.setMetaId(metaId + appendId);
        }
    }
}

