/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.validator.ArraysMathValidator;
import org.sbml.jsbml.ext.arrays.validator.DimensionValidator;
import org.sbml.jsbml.ext.arrays.validator.ExtendedSBaseValidator;
import org.sbml.jsbml.ext.arrays.validator.IndexValidator;

public class ArraysValidator {
    public static List<SBMLError> validate(SBMLDocument document) {
        ArrayList<SBMLError> listOfErrors = new ArrayList<SBMLError>();
        Enumeration children = document.children();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            ArraysValidator.validate(document.getModel(), child, listOfErrors);
        }
        return listOfErrors;
    }

    public static List<SBMLError> validate(SBMLDocument document, boolean filter) {
        List<SBMLError> listOfErrors = ArraysValidator.validate(document);
        boolean hasAdded = false;
        if (filter) {
            for (int i = listOfErrors.size() - 1; i >= 0; --i) {
                SBMLError error = listOfErrors.get(i);
                if (error.getCode() != -1) continue;
                if (!hasAdded) {
                    hasAdded = true;
                    continue;
                }
                listOfErrors.remove(error);
            }
        }
        return listOfErrors;
    }

    private static void validate(Model model, TreeNode node, List<SBMLError> listOfErrors) {
        if (node instanceof SBase) {
            listOfErrors.addAll(ExtendedSBaseValidator.validate(model, (SBase)node));
            if (node instanceof Dimension) {
                listOfErrors.addAll(DimensionValidator.validate(model, (Dimension)((Object)node)));
            }
            if (node instanceof Index) {
                listOfErrors.addAll(IndexValidator.validate(model, (Index)((Object)node)));
            }
            if (node instanceof MathContainer) {
                listOfErrors.addAll(ArraysMathValidator.validate(model, (MathContainer)node));
            }
        }
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            ArraysValidator.validate(model, child, listOfErrors);
        }
    }
}

