/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator;

import java.util.ArrayList;
import java.util.List;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLError;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.ext.arrays.validator.constraints.DimensionSizeCheck;

public class DimensionValidator {
    public static List<SBMLError> validate(Model model, Dimension dim) {
        ArrayList<ArraysConstraint> listOfConstraints = new ArrayList<ArraysConstraint>();
        ArrayList<SBMLError> listOfErrors = new ArrayList<SBMLError>();
        DimensionValidator.addConstraints(model, dim, listOfConstraints);
        for (ArraysConstraint constraint : listOfConstraints) {
            constraint.check();
            listOfErrors.addAll(constraint.getListOfErrors());
        }
        return listOfErrors;
    }

    private static void addConstraints(Model model, Dimension dim, List<ArraysConstraint> listOfConstraints) {
        DimensionSizeCheck dimSizeCheck = new DimensionSizeCheck(model, dim);
        listOfConstraints.add(dimSizeCheck);
    }
}

