/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator;

import java.util.ArrayList;
import java.util.List;
import org.sbml.jsbml.Delay;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Priority;
import org.sbml.jsbml.SBMLError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Trigger;
import org.sbml.jsbml.Unit;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.ext.arrays.validator.constraints.DimensionArrayDimCheck;
import org.sbml.jsbml.ext.arrays.validator.constraints.IndexArrayDimCheck;
import org.sbml.jsbml.ext.arrays.validator.constraints.SBaseWithDimensionCheck;

public class ExtendedSBaseValidator {
    public static List<SBMLError> validate(Model model, SBase sbase) {
        ArrayList<ArraysConstraint> listOfConstraints = new ArrayList<ArraysConstraint>();
        ArrayList<SBMLError> listOfErrors = new ArrayList<SBMLError>();
        ExtendedSBaseValidator.addConstraints(model, sbase, listOfConstraints);
        for (ArraysConstraint constraint : listOfConstraints) {
            constraint.check();
            listOfErrors.addAll(constraint.getListOfErrors());
        }
        return listOfErrors;
    }

    private static void addConstraints(Model model, SBase sbase, List<ArraysConstraint> listOfConstraints) {
        if (ExtendedSBaseValidator.canHaveDimension(sbase)) {
            DimensionArrayDimCheck arrayDimCheck = new DimensionArrayDimCheck(model, sbase);
            listOfConstraints.add(arrayDimCheck);
        } else {
            SBaseWithDimensionCheck dimensionCheck = new SBaseWithDimensionCheck(model, sbase);
            listOfConstraints.add(dimensionCheck);
        }
        IndexArrayDimCheck indexArrayDimCheck = new IndexArrayDimCheck(model, sbase);
        listOfConstraints.add(indexArrayDimCheck);
    }

    public static boolean canHaveDimension(SBase sbase) {
        if (sbase instanceof Model) {
            return false;
        }
        if (sbase instanceof FunctionDefinition) {
            return false;
        }
        if (sbase instanceof Unit) {
            return false;
        }
        if (sbase instanceof UnitDefinition) {
            return false;
        }
        if (sbase instanceof KineticLaw) {
            return false;
        }
        if (sbase instanceof Trigger) {
            return false;
        }
        if (sbase instanceof Priority) {
            return false;
        }
        if (sbase instanceof Delay) {
            return false;
        }
        if (sbase instanceof ListOf) {
            return false;
        }
        if (sbase instanceof Dimension) {
            return false;
        }
        return !(sbase instanceof Index);
    }
}

