/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.arrays.validator.constraints;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.arrays.ArraysConstants;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.Dimension;
import org.sbml.jsbml.ext.arrays.Index;
import org.sbml.jsbml.ext.arrays.util.ArraysMath;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysConstraint;
import org.sbml.jsbml.util.ResourceManager;

public class IndexAttributesCheck
extends ArraysConstraint {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.ext.arrays.validator.constraints.Messages");
    private final Index index;
    private static final Logger logger = Logger.getLogger(IndexAttributesCheck.class);

    public IndexAttributesCheck(Model model, Index index) {
        super(model);
        this.index = index;
    }

    @Override
    public void check() {
        boolean isBounded;
        boolean isStaticComp;
        int arrayDimension;
        Dimension dim;
        String refValue;
        boolean isComp = false;
        if (this.model == null || this.index == null) {
            return;
        }
        String refAttribute = this.index.getReferencedAttribute();
        if (this.index.getParentSBMLObject() == null || this.index.getParentSBMLObject().getParentSBMLObject() == null) {
            logger.debug((Object)MessageFormat.format("WARNING: Index objects must be associated with a parent but {0} does not have a parent. Therefore, validation on Index {0} cannot be performed.", new Object[]{this.index}));
            return;
        }
        SBase parent = this.index.getParentSBMLObject().getParentSBMLObject();
        if (refAttribute == null) {
            String msg = MessageFormat.format("Index objects should have a value for attribute arrays:referencedAttribute. However, the referenced attribute of Index {0} for object {1} doesn't have a value.", this.index.toString(), parent.toString());
            this.logIndexMissingAttribute(msg);
            return;
        }
        String[] parse = refAttribute.split(":");
        if (parse.length == 2 && parse[0].equals("comp")) {
            isComp = true;
        }
        if ((refValue = (String)parent.writeXMLAttributes().get(refAttribute)) == null) {
            if (isComp) {
                String shortMsg = "Array validation has encountered indices for references to variables defined outside this SBML document, so it currently cannot validate whether these indices are valid.";
                String msg = "";
                this.logWarning(msg, shortMsg);
            } else {
                String msg = MessageFormat.format("Index objects attribute arrays:referencedAttribute should reference a valid attribute but {0} of object {1} references an attribute that doesn't exist.", this.index.toString(), parent.toString());
                this.logInvalidRefAttribute(msg);
            }
            return;
        }
        NamedSBase refSBase = this.model.findNamedSBase(refValue);
        if (refSBase == null) {
            if (isComp) {
                String shortMsg = "Array validation has encountered indices for references to variables defined outside this SBML document, so it currently cannot validate whether these indices are valid.";
                String msg = "";
                this.logWarning(msg, shortMsg);
            } else {
                String msg = MessageFormat.format("Index objects should reference a valid SIdRef but {0} of object {1} references an unknown SBase.", this.index.toString(), parent.toString());
                this.logInvalidRefAttribute(msg);
            }
            return;
        }
        ArraysSBasePlugin arraysSBasePlugin = (ArraysSBasePlugin)refSBase.getExtension("arrays");
        if (!this.index.isSetArrayDimension()) {
            String msg = MessageFormat.format("Index objects should have a value for attribute arrays:arrayDimension but SBase {0} has index {1} without a value for arrays:arrayDimension.", parent.toString(), this.index.toString());
            this.logIndexMissingAttribute(msg);
        }
        if ((dim = arraysSBasePlugin.getDimensionByArrayDimension(arrayDimension = this.index.getArrayDimension())) == null) {
            String msg = MessageFormat.format("The SIdRef of an Index object should have arrays:arrayDimension of same value of the Index object. Index {0} is referring to arrays:arrayDimension {1,number,integer} but {2} doesn't have a Dimension object with arrays:arrayDimension {1,number,integer}.", this.index.toString(), arrayDimension, refSBase.toString());
            this.logDimensionMismatch(msg);
        }
        if (!(isStaticComp = ArraysMath.isStaticallyComputable(this.model, this.index))) {
            String msg = MessageFormat.format("Index math should be statically computable, meaning that it should only contain dimension ids or constant values but index {0} of object {1} is not statically computable.", this.index.toString(), parent.toString());
            this.logNotStaticComp(msg);
        }
        if (!(isBounded = ArraysMath.evaluateIndexBounds(this.model, this.index))) {
            if (isComp) {
                String shortMsg = "Array validation has encountered indices for references to variables defined outside this SBML document, so it currently cannot validate whether these indices are valid.";
                String msg = "";
                this.logWarning(msg, shortMsg);
            } else {
                String msg = MessageFormat.format("Index math should not go out-of-bounds but index {0} of object {1} goes out-of-bounds.", this.index.toString(), parent.toString());
                this.logNotBounded(msg);
            }
        }
    }

    private void logWarning(String msg, String shortMsg) {
        int code = -1;
        int severity = 1;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logDimensionMismatch(String shortMsg) {
        int code = 8020305;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexAttributesCheck.logDimensionMismatch");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logNotBounded(String shortMsg) {
        int code = 8020308;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexAttributesCheck.logNotBounded");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logNotStaticComp(String shortMsg) {
        int code = 8020307;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexAttributesCheck.logNotStaticComp");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logIndexMissingAttribute(String shortMsg) {
        int code = 8020302;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexAttributesCheck.logIndexMissingAttribute");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }

    private void logInvalidRefAttribute(String shortMsg) {
        int code = 8020303;
        int severity = 2;
        int category = 0;
        int line = -1;
        int column = -1;
        String pkg = ArraysConstants.packageName;
        String msg = bundle.getString("IndexAttributesCheck.logInvalidRefAttribute");
        this.logFailure(code, severity, category, line, column, pkg, msg, shortMsg);
    }
}

