/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.ext.arrays.ArraysSBasePlugin;
import org.sbml.jsbml.ext.arrays.validator.ExtendedSBaseValidator;
import org.sbml.jsbml.ext.arrays.validator.constraints.ArraysMathCheck;
import org.sbml.jsbml.ext.arrays.validator.constraints.DimensionArrayDimCheck;
import org.sbml.jsbml.ext.arrays.validator.constraints.IndexArrayDimCheck;
import org.sbml.jsbml.ext.arrays.validator.constraints.SBaseWithDimensionCheck;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ArraysUtils;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;

public class ArraysSBasePluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                set.add(8010207);
                set.add(8010211);
                set.add(8020103);
                set.add(8020104);
                set.add(8020107);
                this.addRangeToSet(set, 8020110, 8020111);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 8010207: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        if (c.getExtendedSBase() instanceof MathContainer) {
                            ArraysMathCheck check = new ArraysMathCheck(c.getExtendedSBase().getModel(), (MathContainer)c.getExtendedSBase());
                            check.check();
                            if (check.getListOfErrors().size() > 0) {
                                return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8010207);
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 8010211: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        if (c.getExtendedSBase() instanceof MathContainer) {
                            ArraysMathCheck check = new ArraysMathCheck(c.getExtendedSBase().getModel(), (MathContainer)c.getExtendedSBase());
                            check.check();
                            if (check.getListOfErrors().size() > 0) {
                                return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8010207);
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020103: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        if (ExtendedSBaseValidator.canHaveDimension(c.getExtendedSBase())) {
                            DimensionArrayDimCheck check = new DimensionArrayDimCheck(c.getExtendedSBase().getModel(), c.getExtendedSBase());
                            check.check();
                            if (check.getListOfErrors().size() > 0) {
                                return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8020103);
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020104: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        if (ExtendedSBaseValidator.canHaveDimension(c.getExtendedSBase())) {
                            DimensionArrayDimCheck check = new DimensionArrayDimCheck(c.getExtendedSBase().getModel(), c.getExtendedSBase());
                            check.check();
                            if (check.getListOfErrors().size() > 0) {
                                return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8020104);
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020107: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        if (!ExtendedSBaseValidator.canHaveDimension(c.getExtendedSBase())) {
                            SBaseWithDimensionCheck check = new SBaseWithDimensionCheck(c.getExtendedSBase().getModel(), c.getExtendedSBase());
                            check.check();
                            if (check.getListOfErrors().size() > 0) {
                                return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8020107);
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020110: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        IndexArrayDimCheck check = new IndexArrayDimCheck(c.getExtendedSBase().getModel(), c.getExtendedSBase());
                        check.check();
                        if (check.getListOfErrors().size() > 0) {
                            return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8020110);
                        }
                        return true;
                    }
                };
                break;
            }
            case 8020111: {
                func = new ValidationFunction<ArraysSBasePlugin>(){

                    public boolean check(ValidationContext ctx, ArraysSBasePlugin c) {
                        IndexArrayDimCheck check = new IndexArrayDimCheck(c.getExtendedSBase().getModel(), c.getExtendedSBase());
                        check.check();
                        if (check.getListOfErrors().size() > 0) {
                            return !ArraysUtils.checkListOfErrors(check.getListOfErrors(), 8020111);
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

