/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.comp;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.IdentifierException;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.comp.SBaseRef;
import org.sbml.jsbml.util.IdManager;
import org.sbml.jsbml.validator.SyntaxChecker;

public abstract class AbstractNamedSBaseRef
extends SBaseRef
implements NamedSBase {
    private static final long serialVersionUID = -7590217205832827913L;
    private String id;
    private String name;

    public AbstractNamedSBaseRef() {
        this.id = null;
        this.name = null;
    }

    public AbstractNamedSBaseRef(AbstractNamedSBaseRef nsb) {
        super(nsb);
        this.id = nsb.isSetId() ? new String(nsb.getId()) : null;
        this.name = nsb.isSetName() ? new String(nsb.getName()) : null;
    }

    public AbstractNamedSBaseRef(int level, int version) {
        this();
        this.setLevel(level);
        this.setVersion(version);
    }

    public AbstractNamedSBaseRef(String id) {
        this();
        this.setId(id);
    }

    public AbstractNamedSBaseRef(String id, int level, int version) {
        this(id, null, level, version);
    }

    public AbstractNamedSBaseRef(String id, String name, int level, int version) {
        this(level, version);
        this.setId(id);
        this.setName(name);
    }

    boolean checkIdentifier(String sID) {
        if (sID == null || !SyntaxChecker.isValidId((String)sID, (int)this.getLevel(), (int)this.getVersion())) {
            throw new IllegalArgumentException(MessageFormat.format("\"{0}\" is not a valid identifier for this {1}.", sID, this.getElementName()));
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            NamedSBase nsb = (NamedSBase)object;
            if ((equals &= nsb.isSetId() == this.isSetId()) && this.isSetId()) {
                equals &= nsb.getId().equals(this.getId());
            }
            if ((equals &= nsb.isSetName() == this.isSetName()) && nsb.isSetName()) {
                equals &= nsb.getName().equals(this.getName());
            }
        }
        return equals;
    }

    public String getId() {
        return this.isSetId() ? this.id : "";
    }

    public String getName() {
        return this.isSetName() ? this.name : "";
    }

    @Override
    public int hashCode() {
        int prime = 829;
        int hashCode = super.hashCode();
        if (this.isSetId()) {
            hashCode += 829 * this.getId().hashCode();
        }
        if (this.isSetName()) {
            hashCode += 829 * this.getName().hashCode();
        }
        return hashCode;
    }

    public boolean isSetId() {
        return this.id != null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("id") && this.getLevel() > 1) {
                this.setId(value);
                return true;
            }
            if (attributeName.equals("name")) {
                this.setName(value);
                if (this.isSetLevel() && this.getLevel() == 1) {
                    this.setId(value);
                }
                return true;
            }
        }
        return isAttributeRead;
    }

    public void setId(String id) {
        String property = this.getLevel() == 1 ? "name" : "id";
        String oldId = this.id;
        IdManager idManager = this.getIdManager((SBase)this);
        if (idManager != null) {
            idManager.unregister((SBase)this);
        }
        if (id == null || id.trim().length() == 0) {
            this.id = null;
        } else if (this.checkIdentifier(id)) {
            this.id = id;
        }
        if (idManager != null && !idManager.register((SBase)this)) {
            IdentifierException exc = new IdentifierException((NamedSBase)this, this.id);
            this.id = oldId;
            throw new IllegalArgumentException((Throwable)exc);
        }
        this.firePropertyChange(property, oldId, this.id);
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name == null || name.length() == 0 ? null : name;
        if (!this.isSetId() && this.getLevel() == 1) {
            this.setId(name);
        } else {
            this.firePropertyChange("name", oldName, this.name);
        }
    }

    @Override
    public String toString() {
        if (this.isSetName() && this.getName().length() > 0) {
            return this.name;
        }
        if (this.isSetId()) {
            return this.id;
        }
        return this.getElementName();
    }

    public void unsetId() {
        this.setId(null);
    }

    public void unsetName() {
        this.setName(null);
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            if (this.getLevel() != 1) {
                attributes.put("comp:id", this.getId());
            } else {
                attributes.put("name", this.getId());
            }
        }
        if (this.isSetName()) {
            attributes.put("comp:name", this.getName());
        }
        return attributes;
    }
}

