/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.comp;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.comp.Deletion;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Submodel
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -2588930216065448311L;
    private String modelRef;
    private String timeConversionFactor;
    private String extentConversionFactor;
    private ListOf<Deletion> listOfDeletions;

    public Submodel() {
        this.initDefaults();
    }

    public Submodel(String id) {
        super(id);
        this.initDefaults();
    }

    public Submodel(int level, int version) {
        this(null, null, level, version);
    }

    public Submodel(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Submodel(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public Submodel(Submodel obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetListOfDeletions()) {
            this.setListOfDeletions((ListOf<Deletion>)obj.getListOfDeletions().clone());
        }
        if (obj.isSetModelRef()) {
            this.setModelRef(new String(obj.getModelRef()));
        }
        if (obj.isSetTimeConversionFactor()) {
            this.setTimeConversionFactor(new String(obj.getTimeConversionFactor()));
        }
        if (obj.isSetExtentConversionFactor()) {
            this.setExtentConversionFactor(new String(obj.getExtentConversionFactor()));
        }
    }

    public Submodel clone() {
        return new Submodel(this);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "comp";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extentConversionFactor == null ? 0 : this.extentConversionFactor.hashCode());
        result = 31 * result + (this.listOfDeletions == null ? 0 : this.listOfDeletions.hashCode());
        result = 31 * result + (this.modelRef == null ? 0 : this.modelRef.hashCode());
        result = 31 * result + (this.timeConversionFactor == null ? 0 : this.timeConversionFactor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Submodel other = (Submodel)((Object)obj);
        if (this.extentConversionFactor == null ? other.extentConversionFactor != null : !this.extentConversionFactor.equals(other.extentConversionFactor)) {
            return false;
        }
        if (this.listOfDeletions == null ? other.listOfDeletions != null : !this.listOfDeletions.equals(other.listOfDeletions)) {
            return false;
        }
        if (this.modelRef == null ? other.modelRef != null : !this.modelRef.equals(other.modelRef)) {
            return false;
        }
        return !(this.timeConversionFactor == null ? other.timeConversionFactor != null : !this.timeConversionFactor.equals(other.timeConversionFactor));
    }

    public boolean isIdMandatory() {
        return true;
    }

    public String getModelRef() {
        if (this.isSetModelRef()) {
            return this.modelRef;
        }
        throw new PropertyUndefinedError("modelRef", (SBase)this);
    }

    public boolean isSetModelRef() {
        return this.modelRef != null;
    }

    public void setModelRef(String modelRef) {
        String oldModelRef = this.modelRef;
        this.modelRef = modelRef;
        this.firePropertyChange("modelRef", oldModelRef, this.modelRef);
    }

    public boolean unsetModelRef() {
        if (this.isSetModelRef()) {
            String oldModelRef = this.modelRef;
            this.modelRef = null;
            this.firePropertyChange("modelRef", oldModelRef, this.modelRef);
            return true;
        }
        return false;
    }

    public String getTimeConversionFactor() {
        if (this.isSetTimeConversionFactor()) {
            return this.timeConversionFactor;
        }
        throw new PropertyUndefinedError("timeConversionFactor", (SBase)this);
    }

    public boolean isSetTimeConversionFactor() {
        return this.timeConversionFactor != null;
    }

    public void setTimeConversionFactor(String timeConversionFactor) {
        String oldTimeConversionFactor = this.timeConversionFactor;
        this.timeConversionFactor = timeConversionFactor;
        this.firePropertyChange("timeConversionFactor", oldTimeConversionFactor, this.timeConversionFactor);
    }

    public boolean unsetTimeConversionFactor() {
        if (this.isSetTimeConversionFactor()) {
            String oldTimeConversionFactor = this.timeConversionFactor;
            this.timeConversionFactor = null;
            this.firePropertyChange("timeConversionFactor", oldTimeConversionFactor, this.timeConversionFactor);
            return true;
        }
        return false;
    }

    public String getExtentConversionFactor() {
        if (this.isSetExtentConversionFactor()) {
            return this.extentConversionFactor;
        }
        throw new PropertyUndefinedError("extentConversionFactor", (SBase)this);
    }

    public boolean isSetExtentConversionFactor() {
        return this.extentConversionFactor != null;
    }

    public void setExtentConversionFactor(String extentConversionFactor) {
        String oldExtentConversionFactor = this.extentConversionFactor;
        this.extentConversionFactor = extentConversionFactor;
        this.firePropertyChange("extentConversionFactor", oldExtentConversionFactor, this.extentConversionFactor);
    }

    public boolean unsetExtentConversionFactor() {
        if (this.isSetExtentConversionFactor()) {
            String oldExtentConversionFactor = this.extentConversionFactor;
            this.extentConversionFactor = null;
            this.firePropertyChange("extentConversionFactor", oldExtentConversionFactor, this.extentConversionFactor);
            return true;
        }
        return false;
    }

    public boolean isSetListOfDeletions() {
        return this.listOfDeletions != null && !this.listOfDeletions.isEmpty();
    }

    public int getDeletionCount() {
        if (!this.isSetListOfDeletions()) {
            return 0;
        }
        return this.getListOfDeletions().size();
    }

    public ListOf<Deletion> getListOfDeletions() {
        if (!this.isSetListOfDeletions()) {
            this.listOfDeletions = new ListOf(this.getLevel(), this.getVersion());
            this.listOfDeletions.setPackageVersion(-1);
            this.listOfDeletions.setPackageName(null);
            this.listOfDeletions.setPackageName("comp");
            this.listOfDeletions.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfDeletions);
        }
        return this.listOfDeletions;
    }

    public void setListOfDeletions(ListOf<Deletion> listOfDeletions) {
        this.unsetListOfDeletions();
        this.listOfDeletions = listOfDeletions;
        if (listOfDeletions != null) {
            listOfDeletions.setSBaseListType(ListOf.Type.other);
            listOfDeletions.setPackageVersion(-1);
            listOfDeletions.setPackageName(null);
            listOfDeletions.setPackageName("comp");
        }
        this.registerChild((SBase)this.listOfDeletions);
    }

    public boolean unsetListOfDeletions() {
        if (this.isSetListOfDeletions()) {
            ListOf<Deletion> oldDeletions = this.listOfDeletions;
            this.listOfDeletions = null;
            oldDeletions.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addDeletion(Deletion deletion) {
        return this.getListOfDeletions().add((SBase)deletion);
    }

    public boolean removeDeletion(Deletion deletion) {
        if (this.isSetListOfDeletions()) {
            return this.getListOfDeletions().remove((NamedSBase)deletion);
        }
        return false;
    }

    public void removeDeletion(int i) {
        if (!this.isSetListOfDeletions()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfDeletions().remove(i);
    }

    public void removeDeletion(String id) {
        this.getListOfDeletions().removeFirst((Filter)new NameFilter(id));
    }

    public Deletion createDeletion() {
        return this.createDeletion(null);
    }

    public Deletion createDeletion(String id) {
        Deletion deletion = new Deletion(id, this.getLevel(), this.getVersion());
        this.addDeletion(deletion);
        return deletion;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfDeletions()) {
            ++count;
        }
        return count;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfDeletions()) {
            if (pos == index) {
                return this.getListOfDeletions();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("comp:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("comp:name", this.getName());
        }
        if (this.isSetModelRef()) {
            attributes.put("comp:modelRef", this.getModelRef());
        }
        if (this.isSetTimeConversionFactor()) {
            attributes.put("comp:timeConversionFactor", this.getTimeConversionFactor());
        }
        if (this.isSetExtentConversionFactor()) {
            attributes.put("comp:extentConversionFactor", this.getExtentConversionFactor());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("modelRef")) {
                this.setModelRef(value);
            } else if (attributeName.equals("timeConversionFactor")) {
                this.setTimeConversionFactor(value);
            } else if (attributeName.equals("extentConversionFactor")) {
                this.setExtentConversionFactor(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

