/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.JSBML;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.comp.CompConstants;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.ext.comp.CompSBMLDocumentPlugin;
import org.sbml.jsbml.ext.comp.CompSBasePlugin;
import org.sbml.jsbml.ext.comp.SBaseRef;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompParser
extends AbstractReaderWriter
implements PackageParser {
    private Logger logger = Logger.getLogger(CompParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/comp/version1";
    }

    public String getShortLabel() {
        return "comp";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object treeNode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getListOfSBMLElementsToWrite: " + treeNode.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (treeNode instanceof SBase && !(treeNode instanceof Model) && ((SBase)treeNode).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)treeNode).getExtension(this.getNamespaceURI());
            if (sbasePlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
                this.logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(treeNode);
        }
        if (treeNode instanceof Model) {
            String sbmlNamespace = JSBML.getNamespaceFrom((int)((Model)treeNode).getLevel(), (int)((Model)treeNode).getVersion());
            for (Object child : listOfElementsToWrite) {
                if (!(child instanceof AbstractSBase) || ((AbstractSBase)child).getNamespace() != null) continue;
                AbstractSBase sbase = (AbstractSBase)child;
                this.logger.debug((Object)("Found one suspect Model child: " + sbase.getElementName() + ". Setting the SBML namespace to it."));
                sbase.setNamespace(sbmlNamespace);
            }
        }
        return listOfElementsToWrite;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        ListOf listOf;
        Object newElement;
        if (contextObject instanceof SBMLDocument) {
            SBMLDocument sbmlDoc = (SBMLDocument)contextObject;
            CompSBMLDocumentPlugin compSBMLDoc = null;
            if (sbmlDoc.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1") != null) {
                compSBMLDoc = (CompSBMLDocumentPlugin)sbmlDoc.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1");
            } else {
                compSBMLDoc = new CompSBMLDocumentPlugin(sbmlDoc);
                sbmlDoc.addExtension("http://www.sbml.org/sbml/level3/version1/comp/version1", (SBasePlugin)compSBMLDoc);
            }
            if (elementName.equals("listOfExternalModelDefinitions")) {
                return compSBMLDoc.getListOfExternalModelDefinitions();
            }
            if (elementName.equals("listOfModelDefinitions")) {
                return compSBMLDoc.getListOfModelDefinitions();
            }
        } else if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            CompModelPlugin compModel = null;
            if (model.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1") != null) {
                compModel = (CompModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1");
            } else {
                compModel = new CompModelPlugin(model);
                model.addExtension("http://www.sbml.org/sbml/level3/version1/comp/version1", (SBasePlugin)compModel);
            }
            if (elementName.equals("listOfSubmodels")) {
                return compModel.getListOfSubmodels();
            }
            if (elementName.equals("listOfPorts")) {
                return compModel.getListOfPorts();
            }
        } else if (contextObject instanceof Submodel) {
            Submodel submodel = (Submodel)((Object)contextObject);
            if (elementName.equals("listOfDeletions")) {
                return submodel.getListOfDeletions();
            }
        } else if (contextObject instanceof SBaseRef) {
            SBaseRef sBaseRef = (SBaseRef)((Object)contextObject);
            if (elementName.equalsIgnoreCase("sBaseRef")) {
                return sBaseRef.createSBaseRef();
            }
        } else if (contextObject instanceof ListOf && (newElement = this.createListOfChild(listOf = (ListOf)contextObject, elementName)) != null) {
            return newElement;
        }
        if (contextObject instanceof SBase) {
            SBase sbase = (SBase)contextObject;
            CompSBasePlugin compSBase = null;
            if (sbase.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1") != null) {
                compSBase = (CompSBasePlugin)sbase.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1");
            } else {
                compSBase = new CompSBasePlugin(sbase);
                sbase.addExtension("http://www.sbml.org/sbml/level3/version1/comp/version1", (SBasePlugin)compSBase);
            }
            if (elementName.equals("listOfReplacedElements")) {
                return compSBase.getListOfReplacedElements();
            }
            if (elementName.equals("replacedBy")) {
                return compSBase.createReplacedBy();
            }
        }
        return contextObject;
    }

    protected Object createListOfChild(ListOf<?> listOf, String elementName) {
        block14: {
            SBase parentSBase = listOf.getParent();
            if (parentSBase == null) {
                return null;
            }
            if (parentSBase instanceof Model || parentSBase instanceof SBMLDocument) {
                parentSBase = parentSBase.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1");
            }
            if (elementName.equals("replacedBy") || elementName.equals("replacedElement")) {
                parentSBase = parentSBase.getExtension("http://www.sbml.org/sbml/level3/version1/comp/version1");
            }
            String createMethodName = "create" + elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
            Method createMethod = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method '" + createMethodName + "' will be used"));
            }
            try {
                createMethod = parentSBase.getClass().getMethod(createMethodName, null);
                return createMethod.invoke((Object)parentSBase, (Object[])null);
            }
            catch (SecurityException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' is not accessible on " + parentSBase.getClass().getSimpleName()));
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' does not exist on " + parentSBase.getClass().getSimpleName()));
                }
            }
            catch (IllegalArgumentException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (InvocationTargetException e) {
                if (!this.logger.isDebugEnabled()) break block14;
                this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                this.logger.debug((Object)e.getMessage());
            }
        }
        return null;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("writeElement: " + sbmlElementToWrite.getClass().getSimpleName()));
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/comp/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return CompConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "comp";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Model) {
                return new CompModelPlugin((Model)sbase);
            }
            if (sbase instanceof SBMLDocument) {
                return new CompSBMLDocumentPlugin((SBMLDocument)sbase);
            }
            return new CompSBasePlugin(sbase);
        }
        return null;
    }
}

