/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.comp;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.comp.CompSBasePlugin;
import org.sbml.jsbml.ext.comp.Port;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.util.IdManager;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class CompModelPlugin
extends CompSBasePlugin
implements IdManager {
    private static final long serialVersionUID = 7104644706063096211L;
    private static final transient Logger logger = Logger.getLogger(CompModelPlugin.class);
    private ListOf<Port> listOfPorts;
    private ListOf<Submodel> listOfSubmodels;
    private Map<String, Port> mapOfPorts;

    public CompModelPlugin(CompModelPlugin obj) {
        super(obj);
        if (obj.isSetListOfSubmodels()) {
            this.setListOfSubmodels((ListOf<Submodel>)obj.getListOfSubmodels().clone());
        }
        if (obj.isSetListOfPorts()) {
            this.setListOfPorts((ListOf<Port>)obj.getListOfPorts().clone());
        }
    }

    public CompModelPlugin(Model model) {
        super((SBase)model);
    }

    public boolean addPort(Port port) {
        return this.getListOfPorts().add((SBase)port);
    }

    public boolean addSubmodel(Submodel submodel) {
        return this.getListOfSubmodels().add((SBase)submodel);
    }

    @Override
    public CompModelPlugin clone() {
        return new CompModelPlugin(this);
    }

    @Override
    public int hashCode() {
        int prime = 3371;
        int result = super.hashCode();
        result = 3371 * result + (this.listOfPorts == null ? 0 : this.listOfPorts.hashCode());
        result = 3371 * result + (this.listOfSubmodels == null ? 0 : this.listOfSubmodels.hashCode());
        result = 3371 * result + (this.mapOfPorts == null ? 0 : this.mapOfPorts.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CompModelPlugin other = (CompModelPlugin)((Object)obj);
        if (this.listOfPorts == null ? other.listOfPorts != null : !this.listOfPorts.equals(other.listOfPorts)) {
            return false;
        }
        if (this.listOfSubmodels == null ? other.listOfSubmodels != null : !this.listOfSubmodels.equals(other.listOfSubmodels)) {
            return false;
        }
        return !(this.mapOfPorts == null ? other.mapOfPorts != null : !this.mapOfPorts.equals(other.mapOfPorts));
    }

    public Port createPort() {
        return this.createPort(null);
    }

    public Port createPort(String id) {
        Port port = new Port(id);
        this.addPort(port);
        return port;
    }

    public Submodel createSubmodel() {
        return this.createSubmodel(null);
    }

    public Submodel createSubmodel(String id) {
        Submodel submodel = new Submodel(id);
        this.addSubmodel(submodel);
        return submodel;
    }

    public Port findPort(String id) {
        return this.mapOfPorts == null ? null : this.mapOfPorts.get(id);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), childIndex, 0));
        }
        int pos = 0;
        if (this.isSetListOfSubmodels()) {
            if (pos == childIndex) {
                return this.getListOfSubmodels();
            }
            ++pos;
        }
        if (this.isSetListOfPorts()) {
            if (pos == childIndex) {
                return this.getListOfPorts();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfSubmodels()) {
            ++count;
        }
        if (this.isSetListOfPorts()) {
            ++count;
        }
        return count;
    }

    public ListOf<Port> getListOfPorts() {
        if (!this.isSetListOfPorts()) {
            this.listOfPorts = this.extendedSBase != null ? new ListOf(this.extendedSBase.getLevel(), this.extendedSBase.getVersion()) : new ListOf();
            this.listOfPorts.setPackageVersion(-1);
            this.listOfPorts.setPackageName(null);
            this.listOfPorts.setPackageName("comp");
            this.listOfPorts.setSBaseListType(ListOf.Type.other);
            this.listOfPorts.setOtherListName("listOfPorts");
            if (this.extendedSBase != null) {
                this.extendedSBase.registerChild(this.listOfPorts);
            }
        }
        return this.listOfPorts;
    }

    public ListOf<Submodel> getListOfSubmodels() {
        if (!this.isSetListOfSubmodels()) {
            this.listOfSubmodels = this.extendedSBase != null ? new ListOf(this.extendedSBase.getLevel(), this.extendedSBase.getVersion()) : new ListOf();
            this.listOfSubmodels.setPackageVersion(-1);
            this.listOfSubmodels.setPackageName(null);
            this.listOfSubmodels.setPackageName("comp");
            this.listOfSubmodels.setSBaseListType(ListOf.Type.other);
            this.listOfSubmodels.setOtherListName("listOfSubmodels");
            if (this.extendedSBase != null) {
                this.extendedSBase.registerChild(this.listOfSubmodels);
            }
        }
        return this.listOfSubmodels;
    }

    public int getNumPorts() {
        return this.getPortCount();
    }

    public int getNumSubmodels() {
        return this.getSubmodelCount();
    }

    public Port getPort(int index) {
        return (Port)this.getListOfPorts().get(index);
    }

    public Port getPort(String id) {
        return (Port)this.getListOfPorts().get(id);
    }

    public int getPortCount() {
        if (!this.isSetListOfPorts()) {
            return 0;
        }
        return this.getListOfPorts().size();
    }

    public Submodel getSubmodel(int index) {
        return (Submodel)this.getListOfSubmodels().get(index);
    }

    public Submodel getSubmodel(String id) {
        return (Submodel)this.getListOfSubmodels().get(id);
    }

    public int getSubmodelCount() {
        if (!this.isSetListOfSubmodels()) {
            return 0;
        }
        return this.getListOfSubmodels().size();
    }

    public boolean isSetListOfPorts() {
        return this.listOfPorts != null && !this.listOfPorts.isEmpty();
    }

    public boolean isSetListOfSubmodels() {
        return this.listOfSubmodels != null && !this.listOfSubmodels.isEmpty();
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public void removePort(int i) {
        if (!this.isSetListOfPorts()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfPorts().remove(i);
    }

    public boolean removePort(Port port) {
        if (this.isSetListOfPorts()) {
            return this.getListOfPorts().remove((NamedSBase)port);
        }
        return false;
    }

    public void removeSubmodel(int i) {
        if (!this.isSetListOfSubmodels()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfSubmodels().remove(i);
    }

    public boolean removeSubmodel(String id) {
        Submodel removedSM = (Submodel)this.getListOfSubmodels().removeFirst((Filter)new NameFilter(id));
        return removedSM != null;
    }

    public boolean removeSubmodel(Submodel submodel) {
        if (this.isSetListOfSubmodels()) {
            return this.getListOfSubmodels().remove((NamedSBase)submodel);
        }
        return false;
    }

    public void setListOfPorts(ListOf<Port> listOfPorts) {
        this.unsetListOfPorts();
        this.listOfPorts = listOfPorts;
        if (this.listOfPorts != null) {
            listOfPorts.setPackageVersion(-1);
            listOfPorts.setPackageName(null);
            listOfPorts.setPackageName("comp");
            listOfPorts.setSBaseListType(ListOf.Type.other);
            listOfPorts.setOtherListName("listOfPorts");
        }
        if (this.extendedSBase != null) {
            this.extendedSBase.registerChild(this.listOfPorts);
        }
    }

    public void setListOfSubmodels(ListOf<Submodel> listOfSubmodels) {
        this.unsetListOfSubmodels();
        this.listOfSubmodels = listOfSubmodels;
        if (this.listOfSubmodels != null) {
            listOfSubmodels.setPackageVersion(-1);
            listOfSubmodels.setPackageName(null);
            listOfSubmodels.setPackageName("comp");
            listOfSubmodels.setSBaseListType(ListOf.Type.other);
            listOfSubmodels.setOtherListName("listOfSubmodels");
        }
        if (this.extendedSBase != null) {
            this.extendedSBase.registerChild(this.listOfSubmodels);
        }
    }

    public boolean unsetListOfPorts() {
        if (this.isSetListOfPorts()) {
            ListOf<Port> oldPorts = this.listOfPorts;
            this.listOfPorts = null;
            oldPorts.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfSubmodels() {
        if (this.isSetListOfSubmodels()) {
            ListOf<Submodel> oldSubmodels = this.listOfSubmodels;
            this.listOfSubmodels = null;
            oldSubmodels.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        return null;
    }

    public boolean accept(SBase sbase) {
        return sbase instanceof Port;
    }

    public boolean register(SBase sbase) {
        boolean success = true;
        if (sbase instanceof Port) {
            Port port = (Port)sbase;
            if (port.isSetId()) {
                String portId = port.getId();
                if (this.mapOfPorts == null) {
                    this.mapOfPorts = new HashMap<String, Port>();
                }
                if (this.mapOfPorts.containsKey(portId) && this.mapOfPorts.get(portId) != sbase) {
                    logger.error((Object)MessageFormat.format("A Port with the id \"{0}\" is already present in this model {1}. The new element will not be added to the model.", portId, this.isSetExtendedSBase() ? ((Model)this.getExtendedSBase()).getId() : ""));
                    success = false;
                } else {
                    this.mapOfPorts.put(portId, port);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("registered port id={0} in model {1}", portId, this.isSetExtendedSBase() ? ((Model)this.getExtendedSBase()).getId() : ""));
                    }
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to register something that is not a Port: \"{0}\".", sbase));
        }
        return success;
    }

    public boolean unregister(SBase sbase) {
        boolean success = true;
        if (sbase instanceof Port) {
            Port port = (Port)sbase;
            if (port.isSetId()) {
                String portId = port.getId();
                if (this.mapOfPorts == null) {
                    logger.warn((Object)MessageFormat.format("No Port have been registered in this model {0}. Nothing to be done.", this.isSetExtendedSBase() ? ((Model)this.getExtendedSBase()).getId() : ""));
                    return success;
                }
                if (this.mapOfPorts.containsKey(portId)) {
                    this.mapOfPorts.remove(portId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("unregistered port id={0} in model {1}", portId, this.isSetExtendedSBase() ? ((Model)this.getExtendedSBase()).getId() : ""));
                    }
                } else {
                    logger.warn((Object)MessageFormat.format("A Port with the id \"{0}\" is not present in this model {1}. Nothing to be done.", portId, this.isSetExtendedSBase() ? ((Model)this.getExtendedSBase()).getId() : ""));
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to unregister something that is not a Port: \"{0}\".", sbase));
        }
        return success;
    }
}

