/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.comp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Constraint;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.InitialAssignment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.ext.comp.CompSBMLDocumentPlugin;
import org.sbml.jsbml.ext.comp.CompSBasePlugin;
import org.sbml.jsbml.ext.comp.Deletion;
import org.sbml.jsbml.ext.comp.ExternalModelDefinition;
import org.sbml.jsbml.ext.comp.ModelDefinition;
import org.sbml.jsbml.ext.comp.Port;
import org.sbml.jsbml.ext.comp.ReplacedElement;
import org.sbml.jsbml.ext.comp.Submodel;

public class CompFlatteningConverter {
    private static final Logger LOGGER = Logger.getLogger(CompFlatteningConverter.class.getName());
    private List<String> previousModelIDs;
    private List<String> previousModelMetaIDs;
    private ListOf<ModelDefinition> modelDefinitionListOf;
    private ListOf<ExternalModelDefinition> externalModelDefinitionListOf;
    private List<Submodel> listOfSubmodelsToFlatten = new ArrayList<Submodel>();
    private Model flattenedModel;

    public CompFlatteningConverter() {
        this.previousModelIDs = new ArrayList<String>();
        this.previousModelMetaIDs = new ArrayList<String>();
        this.modelDefinitionListOf = new ListOf();
        this.externalModelDefinitionListOf = new ListOf();
        this.flattenedModel = new Model();
    }

    public SBMLDocument flatten(SBMLDocument document) {
        if (document.isPackageEnabled("comp")) {
            CompSBMLDocumentPlugin compSBMLDocumentPlugin = (CompSBMLDocumentPlugin)document.getExtension("comp");
            this.modelDefinitionListOf = compSBMLDocumentPlugin.getListOfModelDefinitions();
            this.externalModelDefinitionListOf = compSBMLDocumentPlugin.getListOfExternalModelDefinitions();
            if (document.isSetModel() && document.getModel().getExtension("comp") != null) {
                CompModelPlugin compModelPlugin = (CompModelPlugin)document.getModel().getExtension("comp");
                this.handlePorts(compModelPlugin, compModelPlugin.getListOfPorts());
                this.replaceElementsInModelDefinition(compModelPlugin, null);
                this.flattenedModel = this.instantiateSubModels(compModelPlugin);
            } else {
                LOGGER.warning("No comp package found in Model. Can not flatten.");
            }
        } else {
            LOGGER.warning("No comp package found in Document. Can not flatten.");
        }
        this.flattenedModel.unsetExtension("comp");
        this.flattenedModel.unsetPlugin("comp");
        document.setModel(this.flattenedModel);
        document.unsetExtension("comp");
        document.disablePackage("comp");
        return document;
    }

    private Model instantiateSubModels(CompModelPlugin compModelPlugin) {
        Model model = compModelPlugin.getExtendedSBase().getModel();
        this.handlePorts(compModelPlugin, compModelPlugin.getListOfPorts());
        this.replaceElementsInModelDefinition(compModelPlugin, null);
        this.flattenedModel = this.mergeModels(this.flattenModel(model), this.flattenedModel);
        if (compModelPlugin.getSubmodelCount() > 0) {
            this.flattenedModel = this.initSubModels(compModelPlugin);
        } else {
            LOGGER.info("No more submodels");
        }
        return this.flattenedModel;
    }

    private void replaceElementsInModelDefinition(CompModelPlugin compModelPlugin, CompSBasePlugin compSBasePlugin) {
        if (compModelPlugin != null || compSBasePlugin != null) {
            ListOf<ReplacedElement> listOfReplacedElements = new ListOf<ReplacedElement>();
            if (compModelPlugin != null) {
                listOfReplacedElements = compModelPlugin.getListOfReplacedElements();
            } else if (compSBasePlugin != null) {
                listOfReplacedElements = compSBasePlugin.getListOfReplacedElements();
            }
            for (ReplacedElement replacedElement : listOfReplacedElements) {
                for (ModelDefinition modelDefinition : this.modelDefinitionListOf) {
                    NamedSBase sBase = modelDefinition.findNamedSBase(replacedElement.getIdRef());
                    if (sBase == null) continue;
                    sBase.removeFromParent();
                }
                if (compModelPlugin == null) continue;
                for (Port port : compModelPlugin.getListOfPorts()) {
                    if (!port.getId().equals(replacedElement.getPortRef())) continue;
                    port.removeFromParent();
                }
            }
        }
    }

    private void handlePorts(CompModelPlugin compModelPlugin, ListOf<Port> listOfPorts) {
        block0: for (Port port : listOfPorts) {
            SBase parentOfPort;
            String idRef = port.getIdRef();
            String metaIDRef = port.getMetaIdRef();
            if (metaIDRef != null && !metaIDRef.isEmpty()) {
                parentOfPort = compModelPlugin.getParent();
                SBase sBase = compModelPlugin.getSBMLDocument().findSBase(idRef);
                this.addSBaseToModel(parentOfPort.getModel(), sBase);
                continue;
            }
            if (idRef == null || idRef.isEmpty()) continue;
            parentOfPort = compModelPlugin.getParent();
            for (ModelDefinition modelDefinition : this.modelDefinitionListOf) {
                NamedSBase sBase = modelDefinition.findNamedSBase(idRef);
                if (sBase == null) continue;
                this.addSBaseToModel(parentOfPort.getModel(), (SBase)sBase);
                continue block0;
            }
        }
        listOfPorts.removeFromParent();
    }

    private Model initSubModels(CompModelPlugin compModelPlugin) {
        ListOf subModelListOf = compModelPlugin.getListOfSubmodels().clone();
        this.replaceElementsInModelDefinition(compModelPlugin, null);
        ListOf<Port> listOfPorts = compModelPlugin.getListOfPorts();
        this.handlePorts(compModelPlugin, listOfPorts);
        for (Submodel submodel : subModelListOf) {
            this.listOfSubmodelsToFlatten.add(submodel);
            ModelDefinition modelDefinition = (ModelDefinition)this.modelDefinitionListOf.get(submodel.getModelRef());
            if (modelDefinition == null) {
                ExternalModelDefinition externalModelDefinition = (ExternalModelDefinition)this.externalModelDefinitionListOf.get(submodel.getModelRef());
                try {
                    SBMLDocument externalDocument = SBMLReader.read((String)externalModelDefinition.getSource());
                    Model flattendExternalModel = this.flatten(externalDocument).getModel();
                    this.flattenedModel = this.mergeModels(this.flattenedModel, flattendExternalModel);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            if (modelDefinition != null && modelDefinition.getExtension("comp") != null) {
                this.initSubModels((CompModelPlugin)modelDefinition.getExtension("comp"));
                continue;
            }
            LOGGER.info("No model definition found in " + submodel.getId() + ".");
        }
        return this.flattenAndMergeModels(this.listOfSubmodelsToFlatten);
    }

    private Model flattenAndMergeModels(List<Submodel> listOfSubmodelsToFlatten) {
        int sizeOfList = listOfSubmodelsToFlatten.size();
        if (sizeOfList >= 2) {
            Submodel last = listOfSubmodelsToFlatten.get(sizeOfList - 1);
            Submodel secondLast = listOfSubmodelsToFlatten.get(sizeOfList - 2);
            this.flattenedModel = this.mergeModels(this.flattenedModel, this.mergeModels(this.flattenSubModel(secondLast), this.flattenSubModel(last)));
            listOfSubmodelsToFlatten.remove((Object)secondLast);
            listOfSubmodelsToFlatten.remove((Object)last);
            this.flattenAndMergeModels(listOfSubmodelsToFlatten);
        } else if (sizeOfList == 1) {
            Submodel last = listOfSubmodelsToFlatten.get(sizeOfList - 1);
            this.flattenedModel = this.mergeModels(this.flattenedModel, this.flattenSubModel(last));
        }
        return this.flattenedModel;
    }

    private Model mergeModels(Model previousModel, Model currentModel) {
        Model mergedModel = new Model();
        if (previousModel != null) {
            mergedModel.setLevel(previousModel.getLevel());
            mergedModel.setVersion(previousModel.getVersion());
            this.mergeListsOfModels(previousModel.getListOfCompartments(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfSpecies(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfFunctionDefinitions(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfRules(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfEvents(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfUnitDefinitions(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfReactions(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfParameters(), previousModel, mergedModel);
            this.mergeListsOfModels(previousModel.getListOfInitialAssignments(), previousModel, mergedModel);
        }
        if (currentModel != null) {
            this.mergeListsOfModels(currentModel.getListOfCompartments(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfSpecies(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfFunctionDefinitions(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfRules(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfEvents(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfUnitDefinitions(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfReactions(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfParameters(), currentModel, mergedModel);
            this.mergeListsOfModels(currentModel.getListOfInitialAssignments(), currentModel, mergedModel);
        }
        return mergedModel;
    }

    private void mergeListsOfModels(ListOf listOfObjects, Model sourceModel, Model targetModel) {
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfReactions) {
            ListOf reactionListOf = sourceModel.getListOfReactions().clone();
            sourceModel.getListOfReactions().removeFromParent();
            for (Reaction reaction : reactionListOf) {
                targetModel.addReaction(reaction.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfCompartments) {
            ListOf compartmentListOf = sourceModel.getListOfCompartments().clone();
            sourceModel.getListOfCompartments().removeFromParent();
            for (Compartment compartment : compartmentListOf) {
                targetModel.addCompartment(compartment.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfConstraints) {
            ListOf constraintListOf = sourceModel.getListOfConstraints().clone();
            sourceModel.getListOfConstraints().removeFromParent();
            for (Constraint constraint : constraintListOf) {
                targetModel.addConstraint(constraint.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfSpecies) {
            ListOf speciesListOf = sourceModel.getListOfSpecies().clone();
            sourceModel.getListOfSpecies().removeFromParent();
            for (Species species : speciesListOf) {
                targetModel.addSpecies(species.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfEvents) {
            ListOf eventListOf = sourceModel.getListOfEvents().clone();
            sourceModel.getListOfEvents().removeFromParent();
            for (Event event : eventListOf) {
                targetModel.addEvent(event.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfFunctionDefinitions) {
            ListOf functionalDefinitionsListOf = sourceModel.getListOfFunctionDefinitions().clone();
            sourceModel.getListOfFunctionDefinitions().removeFromParent();
            for (FunctionDefinition functionalDefinition : functionalDefinitionsListOf) {
                targetModel.addFunctionDefinition(functionalDefinition.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfInitialAssignments) {
            ListOf initialAssignmentListOf = sourceModel.getListOfInitialAssignments().clone();
            sourceModel.getListOfInitialAssignments().removeFromParent();
            for (InitialAssignment initialAssignment : initialAssignmentListOf) {
                targetModel.addInitialAssignment(initialAssignment.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfParameters) {
            ListOf parameterListOf = sourceModel.getListOfParameters().clone();
            sourceModel.getListOfParameters().removeFromParent();
            for (Parameter parameter : parameterListOf) {
                if (parameter.isSetPlugin("comp")) {
                    this.replaceElementsInModelDefinition(null, (CompSBasePlugin)parameter.getExtension("comp"));
                    parameter.unsetPlugin("comp");
                }
                targetModel.addParameter(parameter.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfRules) {
            ListOf ruleListOf = sourceModel.getListOfRules().clone();
            sourceModel.getListOfRules().removeFromParent();
            for (Rule rule : ruleListOf) {
                targetModel.addRule(rule.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfUnitDefinitions) {
            ListOf unitDefinitionListOf = sourceModel.getListOfUnitDefinitions().clone();
            sourceModel.getListOfUnitDefinitions().removeFromParent();
            for (UnitDefinition unit : unitDefinitionListOf) {
                targetModel.addUnitDefinition(unit.clone());
            }
        }
        if (listOfObjects.getSBaseListType() == ListOf.Type.listOfLocalParameters) {
            sourceModel.getLocalParameterCount();
        }
    }

    private Model flattenSubModel(Submodel subModel) {
        Model model = new Model();
        String subModelID = subModel.getId() + "_";
        String subModelMetaID = subModel.getMetaId() + "_";
        while (this.previousModelIDs.contains(subModelID)) {
            subModelID = subModelID + "_";
        }
        while (this.previousModelMetaIDs.contains(subModelMetaID)) {
            subModelMetaID = subModelMetaID + "_";
        }
        if (!this.previousModelIDs.isEmpty()) {
            subModelID = this.previousModelIDs.get(this.previousModelIDs.size() - 1) + subModelID;
        }
        this.previousModelIDs.add(subModelID);
        this.previousModelMetaIDs.add(subModelID);
        if (subModel.getModelRef() != null) {
            ModelDefinition modelOfSubmodel = ((ModelDefinition)this.modelDefinitionListOf.get(subModel.getModelRef())).clone();
            for (Deletion deletion : subModel.getListOfDeletions()) {
                this.modelDefinitionListOf.remove(deletion.getMetaIdRef());
                subModel.removeDeletion(deletion);
            }
            subModel.getListOfDeletions().removeFromParent();
            model = this.flattenModel(modelOfSubmodel);
        }
        return model;
    }

    private void flattenSBaseList(Model modelOfSubmodel, ListOf listOfSBase) {
        ListOf list = listOfSBase;
        for (SBase sBase : list) {
            if (!sBase.getId().equals("")) {
                sBase.setId(modelOfSubmodel.getId() + sBase.getId());
            }
            if (!sBase.getMetaId().equals("")) {
                sBase.setMetaId(modelOfSubmodel.getId() + sBase.getMetaId());
            }
            if (!sBase.isPackageEnabled("comp")) continue;
            CompSBasePlugin compSBasePlugin = (CompSBasePlugin)sBase.getExtension("comp");
            CompModelPlugin compModelPlugin = (CompModelPlugin)modelOfSubmodel.getExtension("comp");
            this.replaceElementsInModelDefinition(compModelPlugin, compSBasePlugin);
        }
    }

    private Model flattenModel(Model modelOfSubmodel) {
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfReactions());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfCompartments());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfConstraints());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfEvents());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfFunctionDefinitions());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfParameters());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfRules());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfSpecies());
        this.flattenSBaseList(modelOfSubmodel, modelOfSubmodel.getListOfUnitDefinitions());
        return modelOfSubmodel;
    }

    private void addSBaseToModel(Model model, SBase sBase) {
        if (model != null && sBase != null) {
            sBase.removeFromParent();
            if (sBase.getClass() == Reaction.class) {
                model.addReaction((Reaction)sBase);
            } else if (sBase.getClass() == Compartment.class) {
                model.addCompartment((Compartment)sBase);
            } else if (sBase.getClass() == Constraint.class) {
                model.addConstraint((Constraint)sBase);
            } else if (sBase.getClass() == Event.class) {
                model.addEvent((Event)sBase);
            } else if (sBase.getClass() == FunctionDefinition.class) {
                model.addFunctionDefinition((FunctionDefinition)sBase);
            } else if (sBase.getClass() == Parameter.class) {
                model.addParameter((Parameter)sBase);
            } else if (sBase.getClass() == Rule.class) {
                model.addRule((Rule)sBase);
            } else if (sBase.getClass() == Species.class) {
                model.addSpecies((Species)sBase);
            } else if (sBase.getClass() == UnitDefinition.class) {
                model.addUnitDefinition((UnitDefinition)sBase);
            }
        }
    }
}

