/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.comp.ExternalModelDefinition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ExternalModelDefinitionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020301, 1020310);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1020302: {
                func = new UnknownElementValidationFunction();
                break;
            }
            case 1020303: {
                func = new ValidationFunction<ExternalModelDefinition>(){

                    public boolean check(ValidationContext ctx, ExternalModelDefinition extM) {
                        if (!extM.isSetId() || !extM.isSetSource()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)extM);
                    }
                };
                break;
            }
            case 1020304: {
                break;
            }
            case 1020305: {
                break;
            }
            case 1020306: {
                break;
            }
            case 1020307: {
                break;
            }
            case 1020308: {
                func = new ValidationFunction<ExternalModelDefinition>(){

                    public boolean check(ValidationContext ctx, ExternalModelDefinition extM) {
                        if (extM.isSetModelRef()) {
                            return SyntaxChecker.isValidId((String)extM.getModelRef(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020309: {
                break;
            }
        }
        return func;
    }
}

