/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.ext.comp.Deletion;
import org.sbml.jsbml.ext.comp.ReplacedElement;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ReplacedElementConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1021001, 1021006);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1021001: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        return replEl.isSetPortRef() || replEl.isSetIdRef() || replEl.isSetUnitRef() || replEl.isSetMetaIdRef() || replEl.isSetDeletion();
                    }
                };
                break;
            }
            case 1021002: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        int nbDefined = 0;
                        if (replEl.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetDeletion()) {
                            ++nbDefined;
                        }
                        return nbDefined <= 1;
                    }
                };
                break;
            }
            case 1021003: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        if (!replEl.isSetSubmodelRef()) {
                            return false;
                        }
                        int nbDefined = 0;
                        if (replEl.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        if (replEl.isSetDeletion()) {
                            ++nbDefined;
                        }
                        boolean otherAttributes = new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)replEl);
                        return nbDefined == 1 && otherAttributes;
                    }
                };
                break;
            }
            case 1021004: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        Model m;
                        if (replEl.isSetSubmodelRef() && (m = replEl.getModel()) != null && m.isSetPlugin("comp")) {
                            CompModelPlugin compM = (CompModelPlugin)m.getPlugin("comp");
                            Submodel subModel = compM.getSubmodel(replEl.getSubmodelRef());
                            return subModel != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1021005: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        Model m;
                        if (replEl.isSetDeletion() && (m = replEl.getModel()) != null) {
                            SBase deletion = m.getSBaseById(replEl.getDeletion());
                            return deletion != null && deletion instanceof Deletion;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1021006: {
                func = new ValidationFunction<ReplacedElement>(){

                    public boolean check(ValidationContext ctx, ReplacedElement replEl) {
                        Model m;
                        if (replEl.isSetConversionFactor() && (m = replEl.getModel()) != null) {
                            SBase parameter = m.getSBaseById(replEl.getConversionFactor());
                            return parameter != null && parameter instanceof Parameter;
                        }
                        return true;
                    }
                };
                break;
            }
        }
        return func;
    }
}

