/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.ext.comp.CompSBMLDocumentPlugin;
import org.sbml.jsbml.ext.comp.ExternalModelDefinition;
import org.sbml.jsbml.ext.comp.ModelDefinition;
import org.sbml.jsbml.ext.comp.Port;
import org.sbml.jsbml.ext.comp.SBaseRef;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SBaseRefConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020701, 1020714);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020701: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetPortRef()) {
                            Model m = SBaseRefConstraints.this.getParentModel(sbaseRef);
                            if (m == null) {
                                return true;
                            }
                            if (m.isSetPlugin("comp")) {
                                CompModelPlugin compModel = (CompModelPlugin)m.getPlugin("comp");
                                Port p = compModel.getPort(sbaseRef.getPortRef());
                                return p != null;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020702: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetIdRef()) {
                            Model m = SBaseRefConstraints.this.getParentModel(sbaseRef);
                            if (m == null) {
                                return true;
                            }
                            SBase sb = m.getSBaseById(sbaseRef.getIdRef());
                            return sb != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020703: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetUnitRef()) {
                            Model m = SBaseRefConstraints.this.getParentModel(sbaseRef);
                            if (m == null) {
                                return true;
                            }
                            UnitDefinition sb = m.getUnitDefinition(sbaseRef.getUnitRef());
                            return sb != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020704: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetMetaIdRef()) {
                            Model m = SBaseRefConstraints.this.getParentModel(sbaseRef);
                            if (m == null) {
                                return true;
                            }
                            SBMLDocument doc = m.getSBMLDocument();
                            SBase sb = doc != null ? doc.getElementByMetaId(sbaseRef.getMetaIdRef()) : null;
                            return sb != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020705: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetSBaseRef()) {
                            Model m = SBaseRefConstraints.this.getParentModel(sbaseRef);
                            if (m == null) {
                                return true;
                            }
                            SBMLDocument doc = m.getSBMLDocument();
                            SBase sb = doc != null ? doc.getElementByMetaId(sbaseRef.getMetaIdRef()) : null;
                            return sb != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020706: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetPortRef()) {
                            return SyntaxChecker.isValidId((String)sbaseRef.getPortRef(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020707: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetIdRef()) {
                            return SyntaxChecker.isValidId((String)sbaseRef.getIdRef(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020708: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetUnitRef()) {
                            return SyntaxChecker.isValidId((String)sbaseRef.getUnitRef(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020709: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef sbaseRef) {
                        if (sbaseRef.isSetMetaIdRef()) {
                            return SyntaxChecker.isValidMetaId((String)sbaseRef.getMetaIdRef(), (int)sbaseRef.getLevel(), (int)sbaseRef.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020710: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1020712: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef ref) {
                        return ref.isSetPortRef() || ref.isSetIdRef() || ref.isSetUnitRef() || ref.isSetMetaIdRef();
                    }
                };
                break;
            }
            case 1020713: {
                func = new ValidationFunction<SBaseRef>(){

                    public boolean check(ValidationContext ctx, SBaseRef replBy) {
                        int nbDefined = 0;
                        if (replBy.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        boolean otherAttributes = new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)replBy);
                        return nbDefined == 1 && otherAttributes;
                    }
                };
            }
        }
        return func;
    }

    private Model getParentModel(SBaseRef sbaseRef) {
        SBase parentM = this.getModelOrSubmodel((SBase)sbaseRef);
        Object subModel = null;
        Model m = sbaseRef.getModel();
        if (sbaseRef.getParent() != null && sbaseRef.getParent() instanceof SBaseRef) {
            SBaseRef parent = (SBaseRef)sbaseRef.getParent();
            if (parent.isSetPortRef() && m.isSetPlugin("comp")) {
                CompModelPlugin compModel = (CompModelPlugin)m.getPlugin("comp");
                Port p = compModel.getPort(parent.getPortRef());
                if (p == null) {
                    m = null;
                } else if (p.isSetIdRef()) {
                    Submodel subM = compModel.getSubmodel(p.getIdRef());
                    if (subM != null) {
                        String mStr = subM.getModelRef();
                        SBMLDocument doc = m.getSBMLDocument();
                        if (doc != null && doc.isSetPlugin("comp")) {
                            CompSBMLDocumentPlugin compDoc = (CompSBMLDocumentPlugin)doc.getPlugin("comp");
                            ModelDefinition md = compDoc.getModelDefinition(mStr);
                            ExternalModelDefinition emd = compDoc.getExternalModelDefinition(mStr);
                            if (md != null) {
                                m = md;
                            } else if (emd == null) {
                                m = null;
                            }
                        } else {
                            m = null;
                        }
                    } else {
                        m = null;
                    }
                } else {
                    m = null;
                }
            } else if (parent.isSetIdRef() && m.isSetPlugin("comp")) {
                CompModelPlugin compModel = (CompModelPlugin)m.getPlugin("comp");
                Submodel subM = compModel.getSubmodel(parent.getIdRef());
                if (subM != null) {
                    String mStr = subM.getModelRef();
                    SBMLDocument doc = m.getSBMLDocument();
                    if (doc != null && doc.isSetPlugin("comp")) {
                        CompSBMLDocumentPlugin compDoc = (CompSBMLDocumentPlugin)doc.getPlugin("comp");
                        ModelDefinition md = compDoc.getModelDefinition(mStr);
                        ExternalModelDefinition emd = compDoc.getExternalModelDefinition(mStr);
                        if (md != null) {
                            m = md;
                        } else if (emd == null) {
                            m = null;
                        }
                    } else {
                        m = null;
                    }
                } else {
                    m = null;
                }
            }
        }
        return m;
    }

    public SBase getModelOrSubmodel(SBase sbase) {
        if (sbase instanceof Model) {
            return sbase;
        }
        if (sbase instanceof Submodel) {
            return sbase;
        }
        return sbase.getParentSBMLObject() != null ? this.getModelOrSubmodel(sbase.getParentSBMLObject()) : null;
    }
}

