/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.comp.CompSBMLDocumentPlugin;
import org.sbml.jsbml.ext.comp.ExternalModelDefinition;
import org.sbml.jsbml.ext.comp.ModelDefinition;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SubmodelConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020601, 1020608);
                this.addRangeToSet(set, 1020613, 1020617);
                this.addRangeToSet(set, 1020622, 1020623);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1020602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1020603: {
                func = new DuplicatedElementValidationFunction("listOfDeletions");
                break;
            }
            case 1020604: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetListOfDeletions()) {
                            return subM.getDeletionCount() > 0;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020605: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetListOfDeletions()) {
                            return new UnknownElementValidationFunction().check(ctx, subM.getListOfDeletions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020606: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetListOfDeletions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, subM.getListOfDeletions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020607: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (!subM.isSetId() && !subM.isSetModelRef()) {
                            return false;
                        }
                        return new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)subM);
                    }
                };
                break;
            }
            case 1020608: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetModelRef()) {
                            return SyntaxChecker.isValidId((String)subM.getModelRef(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020613: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetTimeConversionFactor()) {
                            return SyntaxChecker.isValidId((String)subM.getTimeConversionFactor(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020614: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetExtentConversionFactor()) {
                            return SyntaxChecker.isValidId((String)subM.getExtentConversionFactor(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020615: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        if (subM.isSetModelRef()) {
                            SBMLDocument doc = subM.getSBMLDocument();
                            if (subM.getModelRef().equals(doc.getModel().getId())) {
                                return true;
                            }
                            if (doc != null && doc.isSetPlugin("comp")) {
                                CompSBMLDocumentPlugin compDoc = (CompSBMLDocumentPlugin)doc.getPlugin("comp");
                                ModelDefinition md = compDoc.getModelDefinition(subM.getModelRef());
                                ExternalModelDefinition emd = compDoc.getExternalModelDefinition(subM.getModelRef());
                                return md != null || emd != null;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020616: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        Model m;
                        return !subM.isSetModelRef() || (m = subM.getModel()) == null || !subM.getModelRef().equals(m.getId());
                    }
                };
                break;
            }
            case 1020617: {
                break;
            }
            case 1020622: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        Model m;
                        if (subM.isSetTimeConversionFactor() && (m = subM.getModel()) != null) {
                            SBase sbase = m.getSBaseById(subM.getTimeConversionFactor());
                            return sbase != null && sbase instanceof Parameter;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020623: {
                func = new ValidationFunction<Submodel>(){

                    public boolean check(ValidationContext ctx, Submodel subM) {
                        Model m;
                        if (subM.isSetExtentConversionFactor() && (m = subM.getModel()) != null) {
                            SBase sbase = m.getSBaseById(subM.getExtentConversionFactor());
                            return sbase != null && sbase instanceof Parameter;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

