/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class CompModelPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020501, 1020506);
                set.add(1020804);
                set.add(1021010);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020501: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin compM) {
                        return new DuplicatedElementValidationFunction("listOfSubmodels").check(ctx, (TreeNodeWithChangeSupport)compM) && new DuplicatedElementValidationFunction("listOfPorts").check(ctx, (TreeNodeWithChangeSupport)compM);
                    }
                };
                break;
            }
            case 1020502: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin compM) {
                        boolean isValid = true;
                        if (compM.isSetListOfSubmodels()) {
                            boolean bl = isValid = compM.getSubmodelCount() > 0;
                        }
                        if (compM.isSetListOfPorts()) {
                            isValid = isValid && compM.getPortCount() > 0;
                        }
                        return isValid;
                    }
                };
                break;
            }
            case 1020503: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin subM) {
                        if (subM.isSetListOfSubmodels()) {
                            return new UnknownElementValidationFunction().check(ctx, subM.getListOfSubmodels());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020504: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin subM) {
                        if (subM.isSetListOfPorts()) {
                            return new UnknownElementValidationFunction().check(ctx, subM.getListOfPorts());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020505: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin subM) {
                        if (subM.isSetListOfSubmodels()) {
                            return new UnknownAttributeValidationFunction().check(ctx, subM.getListOfSubmodels());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020506: {
                func = new ValidationFunction<CompModelPlugin>(){

                    public boolean check(ValidationContext ctx, CompModelPlugin subM) {
                        if (subM.isSetListOfPorts()) {
                            return new UnknownAttributeValidationFunction().check(ctx, subM.getListOfPorts());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020804: {
                break;
            }
        }
        return func;
    }
}

