/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.ext.comp.CompSBMLDocumentPlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class CompSBMLDocumentPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020201, 1020212);
                set.add(1020714);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020201: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        SBMLDocument doc = (SBMLDocument)compDoc.getExtendedSBase();
                        String required = (String)doc.getSBMLDocumentAttributes().get("comp:required");
                        return required != null;
                    }
                };
                break;
            }
            case 1020202: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        SBMLDocument doc = (SBMLDocument)compDoc.getExtendedSBase();
                        String required = (String)doc.getSBMLDocumentAttributes().get("comp:required");
                        try {
                            StringTools.parseSBMLBooleanStrict((String)required);
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020205: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        return new DuplicatedElementValidationFunction("listOfModelDefinitions").check(ctx, (TreeNodeWithChangeSupport)compDoc);
                    }
                };
                break;
            }
            case 1020206: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        boolean isValid = true;
                        if (compDoc.isSetListOfModelDefinitions()) {
                            boolean bl = isValid = compDoc.getModelDefinitionCount() > 0;
                        }
                        if (compDoc.isSetListOfExternalModelDefinitions()) {
                            isValid = isValid && compDoc.getExternalModelDefinitionCount() > 0;
                        }
                        return isValid;
                    }
                };
                break;
            }
            case 1020207: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        if (compDoc.isSetListOfModelDefinitions()) {
                            return new UnknownElementValidationFunction().check(ctx, compDoc.getListOfModelDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020208: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        if (compDoc.isSetListOfExternalModelDefinitions()) {
                            return new UnknownElementValidationFunction().check(ctx, compDoc.getListOfExternalModelDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020209: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        if (compDoc.isSetListOfModelDefinitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, compDoc.getListOfModelDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020210: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        if (compDoc.isSetListOfExternalModelDefinitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, compDoc.getListOfExternalModelDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020211: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        return new DuplicatedElementValidationFunction("listOfExternalModelDefinitions").check(ctx, (TreeNodeWithChangeSupport)compDoc);
                    }
                };
                break;
            }
            case 1020212: {
                func = new ValidationFunction<CompSBMLDocumentPlugin>(){

                    public boolean check(ValidationContext ctx, CompSBMLDocumentPlugin compDoc) {
                        SBMLDocument doc = (SBMLDocument)compDoc.getExtendedSBase();
                        String required = (String)doc.getSBMLDocumentAttributes().get("comp:required");
                        boolean requiredB = false;
                        try {
                            requiredB = StringTools.parseSBMLBooleanStrict((String)required);
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return requiredB;
                    }
                };
                break;
            }
        }
        return func;
    }
}

