/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.comp.CompSBasePlugin;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;

public class CompSBasePluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020101, 1020105);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020101: {
                func = new DuplicatedElementValidationFunction("listOfReplacedElements");
                break;
            }
            case 1020102: {
                func = new UnknownElementValidationFunction();
                break;
            }
            case 1020103: {
                func = new UnknownAttributeValidationFunction();
                break;
            }
            case 1020104: {
                func = new ValidationFunction<CompSBasePlugin>(){

                    public boolean check(ValidationContext ctx, CompSBasePlugin compSbase) {
                        if (compSbase.isSetListOfReplacedElements()) {
                            return compSbase.getReplacedElementCount() > 0;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1020105: {
                func = new DuplicatedElementValidationFunction("replacedBy");
            }
        }
        return func;
    }
}

